/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.core;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.List;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;

public class TabCompleteScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static TabCompleteScriptEvent instance;
    public TabCompleteEvent event;

    public TabCompleteScriptEvent() {
        instance = this;
    }

    public String getCommand() {
        String cmd;
        String[] args = this.event.getBuffer().trim().split(" ");
        String string = cmd = args.length > 0 ? args[0] : "";
        if (this.event.getSender() instanceof Player) {
            cmd = cmd.replaceFirst("/", "");
        }
        return cmd;
    }

    public String getCurrentArg() {
        int i = this.event.getBuffer().lastIndexOf(32);
        return i > 0 ? this.event.getBuffer().substring(i + 1) : this.getCommand();
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("tab complete");
    }

    @Override
    public String getName() {
        return "TabComplete";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determination.length() > 0 && !TabCompleteScriptEvent.isDefaultDetermination(determinationObj)) {
            this.event.setCompletions((List)ListTag.valueOf(determination, this.getTagContext(path)));
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event.getSender() instanceof Player ? new PlayerTag((Player)this.event.getSender()) : null, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("buffer")) {
            return new ElementTag(this.event.getBuffer());
        }
        if (name.equals("command")) {
            return new ElementTag(this.getCommand());
        }
        if (name.equals("current_arg")) {
            return new ElementTag(this.getCurrentArg());
        }
        if (name.equals("completions")) {
            return new ListTag(this.event.getCompletions());
        }
        if (name.equals("server")) {
            return new ElementTag(this.event.getSender() instanceof ConsoleCommandSender);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

