/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class EntityKilledScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityKilledScriptEvent instance;
    public EntityTag entity;
    public ElementTag cause;
    public ElementTag final_damage;
    public EntityTag damager;
    public EntityTag projectile;
    public EntityDamageEvent event;

    public EntityKilledScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        return cmd.equals("killed") || cmd.equals("kills");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target;
        String cmd = path.eventArgLowerAt(1);
        String arg0 = path.eventArgLowerAt(0);
        String arg2 = path.eventArgLowerAt(2);
        String arg3 = path.eventArgLowerAt(3);
        String attacker = cmd.equals("kills") ? arg0 : (arg2.equals("by") ? arg3 : "");
        String string = target = cmd.equals("kills") ? arg2 : arg0;
        if (!attacker.isEmpty() && (this.damager != null ? !this.cause.asString().equals(attacker) && !this.tryEntity(this.projectile, attacker) && !this.tryEntity(this.damager, attacker) : !this.cause.asString().equals(attacker))) {
            return false;
        }
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityKilled";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isDouble()) {
            this.event.setDamage(((ElementTag)determinationObj).asDouble());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        NPCTag npc;
        PlayerTag player;
        PlayerTag playerTag = player = this.entity.isPlayer() ? EntityTag.getPlayerFrom(this.event.getEntity()) : null;
        if (this.damager != null && player == null && this.damager.isPlayer()) {
            player = EntityTag.getPlayerFrom(this.damager.getBukkitEntity());
        }
        NPCTag nPCTag = npc = this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null;
        if (this.damager != null && npc == null && this.damager.isCitizensNPC()) {
            npc = this.damager.getDenizenNPC();
        }
        return new BukkitScriptEntryData(player, npc);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damage")) {
            return new ElementTag(this.event.getDamage());
        }
        if (name.equals("final_damage")) {
            return this.final_damage;
        }
        if (name.equals("cause")) {
            return this.cause;
        }
        if (name.equals("damager") && this.damager != null) {
            return this.damager.getDenizenObject();
        }
        if (name.equals("projectile") && this.projectile != null) {
            return this.projectile.getDenizenObject();
        }
        if (name.startsWith("damage_")) {
            for (EntityDamageEvent.DamageModifier dm : EntityDamageEvent.DamageModifier.values()) {
                if (!name.equals("damage_" + CoreUtilities.toLowerCase(dm.name()))) continue;
                return new ElementTag(this.event.getDamage(dm));
            }
        }
        return super.getContext(name);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityKilled(EntityDamageEvent event) {
        this.entity = new EntityTag(event.getEntity());
        if (this.entity.isValid() && this.entity.isLivingEntity()) {
            if (event.getFinalDamage() < this.entity.getLivingEntity().getHealth()) {
                return;
            }
        } else {
            return;
        }
        this.final_damage = new ElementTag(event.getFinalDamage());
        this.cause = new ElementTag(CoreUtilities.toLowerCase(event.getCause().name()));
        this.damager = null;
        this.projectile = null;
        if (event instanceof EntityDamageByEntityEvent) {
            this.damager = new EntityTag(((EntityDamageByEntityEvent)event).getDamager());
            if (this.damager.isProjectile()) {
                this.projectile = this.damager;
                if (this.damager.hasShooter()) {
                    this.damager = this.damager.getShooter();
                }
            }
        }
        this.event = event;
        this.fire((Event)event);
    }
}

