/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_15.impl.network.packets;

import com.denizenscript.denizen.nms.interfaces.packets.PacketOutTradeList;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizen.nms.util.TradeOffer;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.v1_15_R1.ItemStack;
import net.minecraft.server.v1_15_R1.MerchantRecipe;
import net.minecraft.server.v1_15_R1.MerchantRecipeList;
import net.minecraft.server.v1_15_R1.PacketPlayOutOpenWindowMerchant;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;

public class PacketOutTradeListImpl
implements PacketOutTradeList {
    private PacketPlayOutOpenWindowMerchant internal;
    private int container;
    private List<TradeOffer> tradeOffers;
    private static final Map<String, Field> FIELDS = ReflectionHelper.getFields(PacketPlayOutOpenWindowMerchant.class);
    private static final Field CONTAINER = FIELDS.get("a");
    private static final Field RECIPE_LIST = FIELDS.get("b");

    public PacketOutTradeListImpl(PacketPlayOutOpenWindowMerchant internal) {
        this.internal = internal;
        try {
            this.container = (Integer)CONTAINER.get(internal);
            MerchantRecipeList list = (MerchantRecipeList)RECIPE_LIST.get(internal);
            this.tradeOffers = new ArrayList<TradeOffer>();
            for (MerchantRecipe recipe : list) {
                this.tradeOffers.add(new TradeOffer(CraftItemStack.asBukkitCopy((ItemStack)recipe.sellingItem), CraftItemStack.asBukkitCopy((ItemStack)recipe.buyingItem1), CraftItemStack.asBukkitCopy((ItemStack)recipe.buyingItem2), recipe.isFullyUsed(), recipe.uses, recipe.maxUses, recipe.rewardExp, recipe.xp, recipe.priceMultiplier));
            }
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
        }
    }

    @Override
    public List<TradeOffer> getTradeOffers() {
        return this.tradeOffers;
    }

    @Override
    public void setTradeOffers(List<TradeOffer> tradeOffers) {
        MerchantRecipeList list = new MerchantRecipeList();
        for (TradeOffer offer : tradeOffers) {
            MerchantRecipe recipe = new MerchantRecipe(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)offer.getFirstCost()), CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)offer.getSecondCost()), CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)offer.getProduct()), offer.getCurrentUses(), offer.getMaxUses(), offer.xp, offer.priceMultiplier);
            recipe.rewardExp = offer.rewardExp;
            list.add((Object)recipe);
        }
        try {
            RECIPE_LIST.set(this.internal, list);
        }
        catch (IllegalAccessException e) {
            Debug.echoError(e);
        }
    }
}

