/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.ParticleHelper;
import com.denizenscript.denizen.nms.interfaces.Particle;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class PlayEffectCommand
extends AbstractCommand {
    public PlayEffectCommand() {
        this.setName("playeffect");
        this.setSyntax("playeffect [effect:<name>] [at:<location>|...] (data:<#.#>) (special_data:<data>) (visibility:<#.#>) (quantity:<#>) (offset:<#.#>,<#.#>,<#.#>) (targets:<player>|...)");
        this.setRequiredArguments(2, 8);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ParticleHelper particleHelper = NMSHandler.getParticleHelper();
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentList(LocationTag.class)) {
                if (arg.matchesPrefix("at")) {
                    scriptEntry.addObject("no_offset", new ElementTag(true));
                }
                scriptEntry.addObject("location", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack") || scriptEntry.hasObject("blockcrack") || scriptEntry.hasObject("blockdust"))) {
                MaterialTag material;
                if (particleHelper.hasParticle(arg.getValue())) {
                    scriptEntry.addObject("particleeffect", particleHelper.getParticle(arg.getValue()));
                    continue;
                }
                if (arg.matches("random")) {
                    List<Particle> visible = particleHelper.getVisibleParticles();
                    scriptEntry.addObject("particleeffect", visible.get(CoreUtilities.getRandom().nextInt(visible.size())));
                    continue;
                }
                if (arg.startsWith("iconcrack_")) {
                    Deprecations.oldPlayEffectSpecials.warn(scriptEntry);
                    String shrunk = arg.getValue().substring("iconcrack_".length());
                    ItemTag item = ItemTag.valueOf(shrunk, scriptEntry.entryData.getTagContext());
                    if (item != null) {
                        scriptEntry.addObject("iconcrack", item);
                        continue;
                    }
                    Debug.echoError("Invalid iconcrack_[item]. Must be a valid ItemTag!");
                    continue;
                }
                if (arg.startsWith("blockcrack_")) {
                    Deprecations.oldPlayEffectSpecials.warn(scriptEntry);
                    String shrunk = arg.getValue().substring("blockcrack_".length());
                    material = MaterialTag.valueOf(shrunk);
                    if (material != null) {
                        scriptEntry.addObject("blockcrack", material);
                        continue;
                    }
                    Debug.echoError("Invalid blockcrack_[item]. Must be a valid MaterialTag!");
                    continue;
                }
                if (arg.startsWith("blockdust_")) {
                    Deprecations.oldPlayEffectSpecials.warn(scriptEntry);
                    String shrunk = arg.getValue().substring("blockdust_".length());
                    material = MaterialTag.valueOf(shrunk);
                    if (material != null) {
                        scriptEntry.addObject("blockdust", material);
                        continue;
                    }
                    Debug.echoError("Invalid blockdust_[item]. Must be a valid MaterialTag!");
                    continue;
                }
                if (arg.matchesEnum((Enum<?>[])Effect.values())) {
                    scriptEntry.addObject("effect", Effect.valueOf((String)arg.getValue().toUpperCase()));
                    continue;
                }
                if (NMSHandler.getParticleHelper().effectRemap.containsKey(arg.getValue().toUpperCase())) {
                    scriptEntry.addObject("effect", NMSHandler.getParticleHelper().effectRemap.get(arg.getValue().toUpperCase()));
                }
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesFloat() && arg.matchesPrefix("visibility", "v", "radius", "r")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesFloat() && arg.matchesPrefix("data", "d")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("special_data") && arg.matchesPrefix("special_data")) {
                scriptEntry.addObject("special_data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesInteger() && arg.matchesPrefix("qty", "q", "quantity")) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesFloat() && arg.matchesPrefix("offset", "o")) {
                double offset = arg.asElement().asDouble();
                scriptEntry.addObject("offset", new LocationTag(null, offset, offset, offset));
                continue;
            }
            if (!scriptEntry.hasObject("offset") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("offset", "o")) {
                scriptEntry.addObject("offset", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesArgumentList(PlayerTag.class) && arg.matchesPrefix("targets", "target", "t")) {
                scriptEntry.addObject("targets", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", Utilities.entryHasNPC(scriptEntry) && Utilities.getEntryNPC(scriptEntry).isSpawned() ? Arrays.asList(Utilities.getEntryNPC(scriptEntry).getLocation()) : null, Utilities.entryHasPlayer(scriptEntry) && Utilities.getEntryPlayer(scriptEntry).isOnline() ? Arrays.asList(Utilities.getEntryPlayer(scriptEntry).getLocation()) : null);
        scriptEntry.defaultObject("data", new ElementTag(0));
        scriptEntry.defaultObject("radius", new ElementTag(15));
        scriptEntry.defaultObject("qty", new ElementTag(1));
        scriptEntry.defaultObject("offset", new LocationTag(null, 0.5, 0.5, 0.5));
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("particleeffect") || scriptEntry.hasObject("iconcrack") || scriptEntry.hasObject("blockcrack") || scriptEntry.hasObject("blockdust"))) {
            throw new InvalidArgumentsException("Missing effect argument!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List locations = (List)scriptEntry.getObject("location");
        List targets = (List)scriptEntry.getObject("targets");
        Effect effect = (Effect)scriptEntry.getObject("effect");
        Particle particleEffect = (Particle)scriptEntry.getObject("particleeffect");
        ItemTag iconcrack = (ItemTag)scriptEntry.getObjectTag("iconcrack");
        MaterialTag blockcrack = (MaterialTag)scriptEntry.getObjectTag("blockcrack");
        MaterialTag blockdust = (MaterialTag)scriptEntry.getObjectTag("blockdust");
        ElementTag radius = scriptEntry.getElement("radius");
        ElementTag data = scriptEntry.getElement("data");
        ElementTag qty = scriptEntry.getElement("qty");
        ElementTag no_offset = scriptEntry.getElement("no_offset");
        boolean should_offset = no_offset == null || !no_offset.asBoolean();
        LocationTag offset = (LocationTag)scriptEntry.getObjectTag("offset");
        ElementTag special_data = scriptEntry.getElement("special_data");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (effect != null ? ArgumentHelper.debugObj("effect", effect.name()) : (particleEffect != null ? ArgumentHelper.debugObj("special effect", particleEffect.getName()) : (iconcrack != null ? iconcrack.debug() : (blockcrack != null ? blockcrack.debug() : blockdust.debug())))) + ArgumentHelper.debugObj("locations", locations.toString()) + (targets != null ? ArgumentHelper.debugObj("targets", targets.toString()) : "") + radius.debug() + data.debug() + qty.debug() + offset.debug() + (special_data != null ? special_data.debug() : "") + (should_offset ? ArgumentHelper.debugObj("note", "Location will be offset 1 block-height upward (see documentation)") : ""));
        }
        for (LocationTag location : locations) {
            if (should_offset) {
                location = new LocationTag(location.clone().add(0.0, 1.0, 0.0));
            }
            if (effect != null) {
                for (int n = 0; n < qty.asInt(); ++n) {
                    if (targets != null) {
                        for (PlayerTag player : targets) {
                            if (!player.isValid() || !player.isOnline()) continue;
                            player.getPlayerEntity().playEffect((Location)location, effect, data.asInt());
                        }
                        continue;
                    }
                    location.getWorld().playEffect((Location)location, effect, data.asInt(), radius.asInt());
                }
                continue;
            }
            if (particleEffect != null) {
                float osX = (float)offset.getX();
                float osY = (float)offset.getY();
                float osZ = (float)offset.getZ();
                ArrayList<Player> players = new ArrayList<Player>();
                if (targets == null) {
                    float rad = radius.asFloat();
                    for (Player player : location.getWorld().getPlayers()) {
                        if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                        players.add(player);
                    }
                } else {
                    for (PlayerTag playerTag : targets) {
                        if (!playerTag.isValid() || !playerTag.isOnline()) continue;
                        players.add(playerTag.getPlayerEntity());
                    }
                }
                for (Player player : players) {
                    Class clazz = particleEffect.neededData();
                    if (clazz == null) {
                        particleEffect.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat());
                        continue;
                    }
                    ItemStack dataObject = null;
                    if (special_data == null) {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Missing required special data for particle: " + particleEffect.getName());
                    } else if (clazz == Particle.DustOptions.class) {
                        ListTag dataList = ListTag.valueOf(special_data.asString(), scriptEntry.getContext());
                        if (dataList.size() != 2) {
                            Debug.echoError(scriptEntry.getResidingQueue(), "DustOptions special_data must have 2 list entries for particle: " + particleEffect.getName());
                        } else {
                            float size = Float.parseFloat((String)dataList.get(0));
                            ColorTag color = ColorTag.valueOf((String)dataList.get(1));
                            dataObject = new Particle.DustOptions(color.getColor(), size);
                        }
                    } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) && clazz == BlockData.class) {
                        MaterialTag blockMaterial = MaterialTag.valueOf(special_data.asString(), scriptEntry.getContext());
                        dataObject = blockMaterial.getModernData().data;
                    } else if (clazz == ItemStack.class) {
                        ItemTag itemType = ItemTag.valueOf(special_data.asString(), scriptEntry.getContext());
                        dataObject = itemType.getItemStack();
                    } else {
                        Debug.echoError(scriptEntry.getResidingQueue(), "Unknown particle data type: " + clazz.getCanonicalName() + " for particle: " + particleEffect.getName());
                    }
                    particleEffect.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), dataObject);
                }
                continue;
            }
            ArrayList<Player> players = new ArrayList<Player>();
            if (targets == null) {
                float rad = radius.asFloat();
                for (Player player : location.getWorld().getPlayers()) {
                    if (!(player.getLocation().distanceSquared((Location)location) < (double)(rad * rad))) continue;
                    players.add(player);
                }
            } else {
                for (PlayerTag player : targets) {
                    if (!player.isValid() || !player.isOnline()) continue;
                    players.add(player.getPlayerEntity());
                }
            }
            if (iconcrack != null) {
                ItemStack itemStack = iconcrack.getItemStack();
                Particle particle = NMSHandler.getParticleHelper().getParticle("ITEM_CRACK");
                for (Player player : players) {
                    particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), itemStack);
                }
                continue;
            }
            if (blockcrack != null) {
                MaterialData materialData = blockcrack.getMaterialData();
                Particle particle = NMSHandler.getParticleHelper().getParticle("BLOCK_CRACK");
                for (Player player : players) {
                    particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), materialData);
                }
                continue;
            }
            MaterialData materialData = blockdust.getMaterialData();
            Particle particle = NMSHandler.getParticleHelper().getParticle("BLOCK_DUST");
            for (Player player : players) {
                particle.playFor(player, location, qty.asInt(), offset.toVector(), data.asFloat(), materialData);
            }
        }
    }
}

