/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_12.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_12.impl.blocks.BlockDataImpl;
import com.denizenscript.denizen.nms.v1_12.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.Item;
import net.minecraft.server.v1_12_R1.ItemBed;
import net.minecraft.server.v1_12_R1.ItemBlock;
import net.minecraft.server.v1_12_R1.TileEntity;
import net.minecraft.server.v1_12_R1.TileEntitySkull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.FlowerPot;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_12_R1.util.CraftMagicNumbers;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class BlockHelperImpl
implements BlockHelper {
    @Override
    public void applyPhysics(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().applyPhysics(pos, CraftMagicNumbers.getBlock((Material)location.getBlock().getType()), false);
    }

    @Override
    public List<Location> getBlocksList(PortalCreateEvent event) {
        ArrayList<Location> blocks = new ArrayList<Location>();
        for (org.bukkit.block.Block block : event.getBlocks()) {
            blocks.add(block.getLocation());
        }
        return blocks;
    }

    @Override
    public int idFor(Material mat) {
        return mat.getId();
    }

    public <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            Field f = CraftBlockEntityState.class.getDeclaredField("tileEntity");
            f.setAccessible(true);
            return (T)((TileEntity)f.get(cbs));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Debug.echoError(e);
            return null;
        }
    }

    @Override
    public MaterialData getFlowerpotContents(org.bukkit.block.Block block) {
        return ((FlowerPot)block.getState()).getContents();
    }

    @Override
    public void setFlowerpotContents(org.bukkit.block.Block block, MaterialData data) {
        FlowerPot flowerPot = (FlowerPot)block.getState();
        flowerPot.setContents(data);
        flowerPot.update();
    }

    @Override
    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)this.getTE((CraftBlockEntityState)((CraftSkull)skull))).getGameProfile();
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    @Override
    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        TileEntitySkull tileEntity = (TileEntitySkull)this.getTE((CraftBlockEntityState)((CraftSkull)skull));
        tileEntity.setSkullType(SkullType.PLAYER.ordinal());
        tileEntity.setGameProfile(gameProfile);
        skull.getBlock().getState().update();
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.block.Block block) {
        Object tileEntity = this.getTE((CraftBlockEntityState)block.getState());
        if (tileEntity == null) {
            return null;
        }
        return CompoundTagImpl.fromNMSTag(tileEntity.d());
    }

    @Override
    public void setNbtData(org.bukkit.block.Block block, CompoundTag compoundTag) {
        Object tileEntity = this.getTE((CraftBlockEntityState)block.getState());
        if (tileEntity == null) {
            return;
        }
        tileEntity.load(((CompoundTagImpl)compoundTag).toNMSTag());
        tileEntity.update();
    }

    @Override
    public BlockData getBlockData(Material material, byte data) {
        return new BlockDataImpl(material, data);
    }

    @Override
    public BlockData getBlockData(org.bukkit.block.Block block) {
        return new BlockDataImpl(block);
    }

    @Override
    public BlockData getBlockData(String compressedString) {
        return BlockDataImpl.fromCompressedString(compressedString);
    }

    private static Block getBlockFrom(Material material) {
        if (material == Material.FLOWER_POT_ITEM || material == Material.FLOWER_POT) {
            return Blocks.FLOWER_POT;
        }
        net.minecraft.server.v1_12_R1.ItemStack is = CraftItemStack.asNMSCopy((ItemStack)new ItemStack(material));
        if (is == null) {
            return null;
        }
        Item item = is.getItem();
        if (item instanceof ItemBed) {
            return Blocks.BED;
        }
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        return ((ItemBlock)item).getBlock();
    }

    @Override
    public boolean hasBlock(Material material) {
        return BlockHelperImpl.getBlockFrom(material) != null;
    }

    @Override
    public boolean setBlockResistance(Material material, float resistance) {
        Block block = BlockHelperImpl.getBlockFrom(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(Block.class, "durability", block, Float.valueOf(resistance));
        return true;
    }

    @Override
    public float getBlockResistance(Material material) {
        Block block = BlockHelperImpl.getBlockFrom(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(Block.class, "durability", block)).floatValue();
    }

    @Override
    public boolean isSafeBlock(Material material) {
        switch (material) {
            case LEVER: 
            case WOOD_BUTTON: 
            case STONE_BUTTON: 
            case REDSTONE_WIRE: 
            case SAPLING: 
            case SIGN_POST: 
            case WALL_SIGN: 
            case SNOW: 
            case TORCH: 
            case DETECTOR_RAIL: 
            case ACTIVATOR_RAIL: 
            case RAILS: 
            case POWERED_RAIL: 
            case NETHER_WARTS: 
            case NETHER_STALK: 
            case VINE: 
            case SUGAR_CANE_BLOCK: 
            case CROPS: 
            case LONG_GRASS: 
            case RED_MUSHROOM: 
            case BROWN_MUSHROOM: 
            case DEAD_BUSH: 
            case REDSTONE_TORCH_OFF: 
            case REDSTONE_TORCH_ON: 
            case AIR: 
            case YELLOW_FLOWER: 
            case RED_ROSE: {
                return true;
            }
        }
        return false;
    }
}

