/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_13.impl.packets.handlers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizen.nms.v1_13.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_13.impl.entities.EntityFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_13.impl.packets.PacketOutChatImpl;
import com.denizenscript.denizen.nms.v1_13.impl.packets.PacketOutEntityMetadataImpl;
import com.denizenscript.denizen.nms.v1_13.impl.packets.PacketOutSpawnEntityImpl;
import com.denizenscript.denizen.nms.v1_13.impl.packets.handlers.DenizenPacketListenerImpl;
import com.denizenscript.denizen.utilities.packets.DenizenPacketHandler;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.List;
import java.util.UUID;
import javax.crypto.SecretKey;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityPlayer;
import net.minecraft.server.v1_13_R2.EnumProtocol;
import net.minecraft.server.v1_13_R2.EnumProtocolDirection;
import net.minecraft.server.v1_13_R2.IChatBaseComponent;
import net.minecraft.server.v1_13_R2.MathHelper;
import net.minecraft.server.v1_13_R2.NetworkManager;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketDataSerializer;
import net.minecraft.server.v1_13_R2.PacketListener;
import net.minecraft.server.v1_13_R2.PacketPlayOutChat;
import net.minecraft.server.v1_13_R2.PacketPlayOutCustomPayload;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntity;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_13_R2.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_13_R2.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_13_R2.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_13_R2.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.v1_13_R2.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_13_R2.PacketPlayOutSpawnEntityPainting;
import net.minecraft.server.v1_13_R2.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DenizenNetworkManagerImpl
extends NetworkManager {
    public final NetworkManager oldManager;
    public final DenizenPacketListenerImpl packetListener;
    public final EntityPlayer player;
    public final DenizenPacketHandler packetHandler;
    public static Field ENTITY_ID_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get("a");
    public static Field ENTITY_ID_PACKVELENT = ReflectionHelper.getFields(PacketPlayOutEntityVelocity.class).get("a");
    public static Field ENTITY_ID_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("a");
    public static Field POS_X_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("b");
    public static Field POS_Y_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("c");
    public static Field POS_Z_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("d");
    public static Field POS_X_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get("b");
    public static Field POS_Y_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get("c");
    public static Field POS_Z_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get("d");
    private static final Field protocolDirectionField;
    private static final MethodHandle networkManagerField;

    public DenizenNetworkManagerImpl(EntityPlayer entityPlayer, NetworkManager oldManager, DenizenPacketHandler packetHandler) {
        super(DenizenNetworkManagerImpl.getProtocolDirection(oldManager));
        this.oldManager = oldManager;
        this.channel = oldManager.channel;
        this.packetListener = new DenizenPacketListenerImpl(this, entityPlayer);
        oldManager.setPacketListener((PacketListener)this.packetListener);
        this.player = this.packetListener.player;
        this.packetHandler = packetHandler;
    }

    public static void setNetworkManager(Player player, DenizenPacketHandler packetHandler) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection playerConnection = entityPlayer.playerConnection;
        DenizenNetworkManagerImpl.setNetworkManager(playerConnection, new DenizenNetworkManagerImpl(entityPlayer, playerConnection.networkManager, packetHandler));
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelActive(channelhandlercontext);
    }

    public void setProtocol(EnumProtocol enumprotocol) {
        this.oldManager.setProtocol(enumprotocol);
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelInactive(channelhandlercontext);
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        this.oldManager.exceptionCaught(channelhandlercontext, throwable);
    }

    protected void channelRead0(ChannelHandlerContext channelhandlercontext, Packet packet) throws Exception {
        if (this.oldManager.channel.isOpen()) {
            try {
                packet.a((PacketListener)this.packetListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPacketListener(PacketListener packetlistener) {
        this.oldManager.setPacketListener(packetlistener);
    }

    public static Object duplo(Object a2) {
        try {
            Class<?> clazz = a2.getClass();
            Object reter = clazz.newInstance();
            for (Field f : clazz.getDeclaredFields()) {
                f.setAccessible(true);
                f.set(reter, f.get(a2));
            }
            Class<?> subc = clazz;
            while (subc.getSuperclass() != null) {
                subc = subc.getSuperclass();
                for (Field f : subc.getDeclaredFields()) {
                    f.setAccessible(true);
                    f.set(reter, f.get(a2));
                }
            }
            return reter;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return null;
        }
    }

    public void sendPacket(Packet<?> packet) {
        this.sendPacket(packet, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (packet instanceof PacketPlayOutChat) {
            if (this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutChatImpl((PacketPlayOutChat)packet))) return;
            this.oldManager.sendPacket(packet, genericfuturelistener);
            return;
        } else if (packet instanceof PacketPlayOutEntity) {
            try {
                List<UUID> attList;
                int ider = ENTITY_ID_PACKENT.getInt(packet);
                Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    this.oldManager.sendPacket(packet, genericfuturelistener);
                    return;
                }
                if (!NMSHandler.getInstance().attachmentsA.containsKey(e.getUniqueID()) || NMSHandler.getInstance().attachmentsA.get(e.getUniqueID()).equals(this.player.getUniqueID())) {
                    this.oldManager.sendPacket(packet, genericfuturelistener);
                }
                if ((attList = NMSHandler.getInstance().attachments2.get(e.getUniqueID())) == null) return;
                for (UUID att : attList) {
                    org.bukkit.entity.Entity target = Bukkit.getEntity((UUID)att);
                    if (target == null) continue;
                    Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                    ENTITY_ID_PACKENT.setInt(pNew, target.getEntityId());
                    Vector offset = NMSHandler.getInstance().attachmentOffsets.get(att);
                    if (offset != null && (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove || packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook)) {
                        boolean rotationBasis = NMSHandler.getInstance().attachmentRotations.contains(att);
                        Vector goalPosition = !rotationBasis ? new Vector(e.locX, e.locY, e.locZ).add(offset) : new Vector(e.locX, e.locY, e.locZ).add(NMSHandler.fixOffset(offset, -e.yaw, e.pitch));
                        Vector oldPos = NMSHandler.getInstance().visiblePositions.get(target.getUniqueId());
                        if (oldPos == null) {
                            oldPos = target.getLocation().toVector();
                        }
                        Vector moveNeeded = goalPosition.clone().subtract(oldPos);
                        NMSHandler.getInstance().visiblePositions.put(target.getUniqueId(), goalPosition.clone());
                        int offX = (int)(moveNeeded.getX() * 4096.0);
                        int offY = (int)(moveNeeded.getY() * 4096.0);
                        int offZ = (int)(moveNeeded.getZ() * 4096.0);
                        if (offX < Short.MIN_VALUE || offX > Short.MAX_VALUE || offY < Short.MIN_VALUE || offY > Short.MAX_VALUE || offZ < Short.MIN_VALUE || offZ > Short.MAX_VALUE) {
                            PacketPlayOutEntityTeleport newTeleportPacket = new PacketPlayOutEntityTeleport(e);
                            ENTITY_ID_PACKTELENT.setInt(newTeleportPacket, target.getEntityId());
                            POS_X_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getX());
                            POS_Y_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getY());
                            POS_Z_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getZ());
                            this.oldManager.sendPacket((Packet)newTeleportPacket);
                            return;
                        }
                        POS_X_PACKENT.setInt(pNew, MathHelper.clamp((int)offX, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                        POS_Y_PACKENT.setInt(pNew, MathHelper.clamp((int)offY, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                        POS_Z_PACKENT.setInt(pNew, MathHelper.clamp((int)offZ, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    }
                    this.oldManager.sendPacket(pNew);
                }
                return;
            }
            catch (Exception e) {
                Debug.echoError(e);
                return;
            }
        } else if (packet instanceof PacketPlayOutEntityVelocity) {
            try {
                List<UUID> attList;
                int ider = ENTITY_ID_PACKVELENT.getInt(packet);
                Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    this.oldManager.sendPacket(packet, genericfuturelistener);
                    return;
                }
                if (!NMSHandler.getInstance().attachmentsA.containsKey(e.getUniqueID()) || NMSHandler.getInstance().attachmentsA.get(e.getUniqueID()).equals(this.player.getUniqueID())) {
                    this.oldManager.sendPacket(packet, genericfuturelistener);
                }
                if ((attList = NMSHandler.getInstance().attachments2.get(e.getUniqueID())) == null) return;
                for (UUID att : attList) {
                    org.bukkit.entity.Entity target = Bukkit.getEntity((UUID)att);
                    if (target == null) continue;
                    Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                    ENTITY_ID_PACKVELENT.setInt(pNew, target.getEntityId());
                    this.oldManager.sendPacket(pNew);
                }
                return;
            }
            catch (Exception e) {
                Debug.echoError(e);
                return;
            }
        } else if (packet instanceof PacketPlayOutEntityTeleport) {
            try {
                List<UUID> attList;
                int ider = ENTITY_ID_PACKTELENT.getInt(packet);
                Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    this.oldManager.sendPacket(packet, genericfuturelistener);
                    return;
                }
                if (!NMSHandler.getInstance().attachmentsA.containsKey(e.getUniqueID()) || NMSHandler.getInstance().attachmentsA.get(e.getUniqueID()).equals(this.player.getUniqueID())) {
                    this.oldManager.sendPacket(packet, genericfuturelistener);
                }
                if ((attList = NMSHandler.getInstance().attachments2.get(e.getUniqueID())) == null) return;
                for (UUID att : attList) {
                    org.bukkit.entity.Entity target = Bukkit.getEntity((UUID)att);
                    if (target == null) continue;
                    Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                    ENTITY_ID_PACKTELENT.setInt(pNew, target.getEntityId());
                    Vector offset = NMSHandler.getInstance().attachmentOffsets.get(att);
                    Vector resultPos = new Vector(POS_X_PACKTELENT.getDouble(pNew), POS_Y_PACKTELENT.getDouble(pNew), POS_Z_PACKTELENT.getDouble(pNew));
                    if (offset != null) {
                        boolean rotationBasis = NMSHandler.getInstance().attachmentRotations.contains(att);
                        Vector goalOffset = !rotationBasis ? offset : NMSHandler.fixOffset(offset, -e.yaw, e.pitch);
                        POS_X_PACKTELENT.setDouble(pNew, POS_X_PACKTELENT.getDouble(pNew) + goalOffset.getX());
                        POS_Y_PACKTELENT.setDouble(pNew, POS_Y_PACKTELENT.getDouble(pNew) + goalOffset.getY());
                        POS_Z_PACKTELENT.setDouble(pNew, POS_Z_PACKTELENT.getDouble(pNew) + goalOffset.getZ());
                        resultPos.add(goalOffset);
                    }
                    NMSHandler.getInstance().visiblePositions.put(target.getUniqueId(), resultPos);
                    this.oldManager.sendPacket(pNew);
                }
                return;
            }
            catch (Exception e) {
                Debug.echoError(e);
                return;
            }
        } else if (packet instanceof PacketPlayOutNamedEntitySpawn || packet instanceof PacketPlayOutSpawnEntity || packet instanceof PacketPlayOutSpawnEntityLiving || packet instanceof PacketPlayOutSpawnEntityPainting || packet instanceof PacketPlayOutSpawnEntityExperienceOrb) {
            PacketOutSpawnEntityImpl spawnEntity = new PacketOutSpawnEntityImpl(this.player, packet);
            Entity entity = this.player.getWorld().getEntity(spawnEntity.getEntityId());
            if (entity == null) {
                this.oldManager.sendPacket(packet, genericfuturelistener);
                return;
            } else {
                if (NMSHandler.getEntityHelper().isHidden((Player)this.player.getBukkitEntity(), entity.getBukkitEntity().getUniqueId())) return;
                if (entity instanceof EntityFakePlayerImpl) {
                    final EntityFakePlayerImpl fakePlayer = (EntityFakePlayerImpl)entity;
                    this.sendPacket((Packet<?>)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{fakePlayer}));
                    Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            DenizenNetworkManagerImpl.this.sendPacket((Packet<?>)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{fakePlayer}));
                        }
                    }, 5L);
                }
                this.oldManager.sendPacket(packet, genericfuturelistener);
            }
            return;
        } else if (packet instanceof PacketPlayOutPlayerInfo) {
            PacketPlayOutPlayerInfo playerInfo = (PacketPlayOutPlayerInfo)packet;
            if (!ProfileEditorImpl.handleMirrorProfiles(playerInfo, this, genericfuturelistener)) return;
            ProfileEditorImpl.updatePlayerProfiles(playerInfo);
            this.oldManager.sendPacket((Packet)playerInfo);
            return;
        } else if (packet instanceof PacketPlayOutEntityMetadata) {
            if (this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), new PacketOutEntityMetadataImpl((PacketPlayOutEntityMetadata)packet))) return;
            this.oldManager.sendPacket(packet, genericfuturelistener);
            return;
        } else if (packet instanceof PacketPlayOutCustomPayload) {
            PacketPlayOutCustomPayload payload = (PacketPlayOutCustomPayload)packet;
            PacketDataSerializer original = new PacketDataSerializer(Unpooled.buffer());
            try {
                payload.b(original);
                PacketDataSerializer serializer = new PacketDataSerializer(original.getBytes(original.readerIndex(), new byte[original.readableBytes()]));
                payload.a(original);
                this.oldManager.sendPacket(packet, genericfuturelistener);
                return;
            }
            catch (Exception e) {
                this.oldManager.sendPacket(packet, genericfuturelistener);
            }
            return;
        } else {
            this.oldManager.sendPacket(packet, genericfuturelistener);
        }
    }

    public void a() {
        this.oldManager.a();
    }

    public SocketAddress getSocketAddress() {
        return this.oldManager.getSocketAddress();
    }

    public void close(IChatBaseComponent ichatbasecomponent) {
        this.oldManager.close(ichatbasecomponent);
    }

    public boolean isLocal() {
        return this.oldManager.isLocal();
    }

    public void a(SecretKey secretkey) {
        this.oldManager.a(secretkey);
    }

    public boolean isConnected() {
        return this.oldManager.isConnected();
    }

    public boolean h() {
        return this.oldManager.h();
    }

    public PacketListener i() {
        return this.oldManager.i();
    }

    public IChatBaseComponent j() {
        return this.oldManager.j();
    }

    public void stopReading() {
        this.oldManager.stopReading();
    }

    public void setCompressionLevel(int i) {
        this.oldManager.setCompressionLevel(i);
    }

    public void handleDisconnection() {
        this.oldManager.handleDisconnection();
    }

    public SocketAddress getRawAddress() {
        return this.oldManager.getRawAddress();
    }

    private static EnumProtocolDirection getProtocolDirection(NetworkManager networkManager) {
        EnumProtocolDirection direction = null;
        try {
            direction = (EnumProtocolDirection)protocolDirectionField.get(networkManager);
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        return direction;
    }

    private static void setNetworkManager(PlayerConnection playerConnection, NetworkManager networkManager) {
        try {
            networkManagerField.invoke(playerConnection, networkManager);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    static {
        Field directionField = null;
        MethodHandle managerField = null;
        try {
            directionField = NetworkManager.class.getDeclaredField("h");
            directionField.setAccessible(true);
            managerField = ReflectionHelper.getFinalSetter(PlayerConnection.class, "networkManager");
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        protocolDirectionField = directionField;
        networkManagerField = managerField;
    }
}

