/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PigZombie;

public class EntityAnger
implements Property {
    public static final String[] handledTags = new String[]{"anger"};
    public static final String[] handledMechs = new String[]{"anger"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        Entity bukkitEntity = ((EntityTag)entity).getBukkitEntity();
        return bukkitEntity instanceof PigZombie || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_15) && bukkitEntity instanceof Bee;
    }

    public static EntityAnger getFrom(ObjectTag entity) {
        if (!EntityAnger.describes(entity)) {
            return null;
        }
        return new EntityAnger((EntityTag)entity);
    }

    private EntityAnger(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getAnger());
    }

    @Override
    public String getPropertyId() {
        return "anger";
    }

    public int getAnger() {
        if (this.entity.getBukkitEntity() instanceof PigZombie) {
            return ((PigZombie)this.entity.getBukkitEntity()).getAnger();
        }
        return ((Bee)this.entity.getBukkitEntity()).getAnger();
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("anger")) {
            return new ElementTag(this.getAnger()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("anger") && mechanism.requireInteger()) {
            if (this.entity.getBukkitEntity() instanceof PigZombie) {
                ((PigZombie)this.entity.getBukkitEntity()).setAnger(mechanism.getValue().asInt());
            } else {
                ((Bee)this.entity.getBukkitEntity()).setAnger(mechanism.getValue().asInt());
            }
        }
    }
}

