/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.BlockSet;
import com.denizenscript.denizen.utilities.blocks.CuboidBlockSet;
import com.denizenscript.denizen.utilities.blocks.MCEditSchematicHelper;
import com.denizenscript.denizen.utilities.blocks.SpongeSchematicHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.plugin.Plugin;

public class SchematicCommand
extends AbstractCommand
implements Holdable,
Listener {
    public static boolean noPhys = false;
    public static Map<String, CuboidBlockSet> schematics;

    public SchematicCommand() {
        this.setName("schematic");
        this.setSyntax("schematic [create/load/unload/rotate (angle:<#>)/paste (fake_to:<player>|... fake_duration:<duration>)/save/flip_x/flip_y/flip_z) (noair) (mask:<material>|...)] [name:<name>] (filename:<name>) (<location>) (<cuboid>) (delayed)");
        this.setRequiredArguments(2, 10);
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                SchematicCommand.this.schematicTags(event);
            }
        }, "schematic", "schem");
        schematics = new HashMap<String, CuboidBlockSet>();
        noPhys = false;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (noPhys) {
            event.setCancelled(true);
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", new ElementTag(arg.raw_value.toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("name") && arg.matchesPrefix("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("filename") && arg.matchesPrefix("filename")) {
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("angle") && arg.matchesPrefix("angle") && arg.matchesInteger()) {
                scriptEntry.addObject("angle", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("delayed") && arg.matches("delayed")) {
                scriptEntry.addObject("delayed", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("noair") && arg.matches("noair")) {
                scriptEntry.addObject("noair", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("mask") && arg.matchesPrefix("mask") && arg.matchesArgumentList(MaterialTag.class)) {
                scriptEntry.addObject("mask", arg.asType(ListTag.class).filter(MaterialTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("fake_to") && arg.matchesPrefix("fake_to") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("fake_to", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("fake_duration") && arg.matchesPrefix("fake_duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("fake_duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("cuboid") && arg.matchesArgumentType(CuboidTag.class)) {
                scriptEntry.addObject("cuboid", arg.asType(CuboidTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (scriptEntry.shouldWaitFor()) {
            scriptEntry.addObject("delayed", new ElementTag("true"));
        }
        if (!scriptEntry.hasObject("type")) {
            throw new InvalidArgumentsException("Missing type argument!");
        }
        if (!scriptEntry.hasObject("name")) {
            throw new InvalidArgumentsException("Missing name argument!");
        }
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        ElementTag angle = scriptEntry.getElement("angle");
        ElementTag type = scriptEntry.getElement("type");
        ElementTag name = scriptEntry.getElement("name");
        ElementTag filename = scriptEntry.getElement("filename");
        ElementTag noair = scriptEntry.getElement("noair");
        ElementTag delayed = scriptEntry.getElement("delayed");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        List mask = (List)scriptEntry.getObject("mask");
        List fakeTo = (List)scriptEntry.getObject("fake_to");
        DurationTag fakeDuration = (DurationTag)scriptEntry.getObjectTag("fake_duration");
        CuboidTag cuboid = (CuboidTag)scriptEntry.getObjectTag("cuboid");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), type.debug() + name.debug() + (location != null ? location.debug() : "") + (filename != null ? filename.debug() : "") + (cuboid != null ? cuboid.debug() : "") + (angle != null ? angle.debug() : "") + (noair != null ? noair.debug() : "") + (delayed != null ? delayed.debug() : "") + (mask != null ? ArgumentHelper.debugList("mask", mask) : "") + (fakeTo != null ? ArgumentHelper.debugList("fake_to", fakeTo) : "") + (fakeDuration != null ? fakeDuration.debug() : ""));
        }
        Type ttype = Type.valueOf(type.asString());
        String fname = filename != null ? filename.asString() : name.asString();
        switch (ttype) {
            case CREATE: {
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is already loaded.");
                    return;
                }
                if (cuboid == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Missing cuboid argument!");
                    return;
                }
                if (location == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Missing origin location argument!");
                    return;
                }
                try {
                    if (delayed != null && delayed.asBoolean()) {
                        CuboidBlockSet set = new CuboidBlockSet();
                        set.buildDelayed(cuboid, location, () -> {
                            schematics.put(name.asString().toUpperCase(), set);
                            scriptEntry.setFinished(true);
                        });
                    } else {
                        scriptEntry.setFinished(true);
                        CuboidBlockSet set = new CuboidBlockSet(cuboid, location);
                        schematics.put(name.asString().toUpperCase(), set);
                    }
                }
                catch (Exception ex) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Error creating schematic object " + name.asString() + ".");
                    Debug.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
                scriptEntry.setFinished(true);
                break;
            }
            case LOAD: {
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is already loaded.");
                    return;
                }
                String directory = URLDecoder.decode(System.getProperty("user.dir"));
                File f = new File(directory + "/plugins/Denizen/schematics/" + fname + ".schem");
                if (!Utilities.canReadFile(f)) {
                    Debug.echoError("Server config denies reading files in that location.");
                    return;
                }
                if (!f.exists() && !(f = new File(directory + "/plugins/Denizen/schematics/" + fname + ".schematic")).exists()) {
                    Debug.echoError("Schematic file " + fname + " does not exist. Are you sure it's in " + directory + "/plugins/Denizen/schematics/?");
                    return;
                }
                File schemFile = f;
                Runnable loadRunnable = () -> {
                    try {
                        FileInputStream fs = new FileInputStream(schemFile);
                        CuboidBlockSet newSet = schemFile.getName().endsWith(".schem") ? SpongeSchematicHelper.fromSpongeStream(fs) : MCEditSchematicHelper.fromMCEditStream(fs);
                        ((InputStream)fs).close();
                        Bukkit.getScheduler().runTask((Plugin)DenizenAPI.getCurrentInstance(), () -> {
                            schematics.put(name.asString().toUpperCase(), newSet);
                            scriptEntry.setFinished(true);
                        });
                    }
                    catch (Exception ex) {
                        Bukkit.getScheduler().runTask((Plugin)DenizenAPI.getCurrentInstance(), () -> {
                            Debug.echoError(scriptEntry.getResidingQueue(), "Error loading schematic file " + name.asString() + ".");
                            Debug.echoError(scriptEntry.getResidingQueue(), ex);
                        });
                        return;
                    }
                };
                if (delayed != null && delayed.asBoolean()) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)DenizenAPI.getCurrentInstance(), loadRunnable);
                    break;
                }
                loadRunnable.run();
                scriptEntry.setFinished(true);
                break;
            }
            case UNLOAD: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.remove(name.asString().toUpperCase());
                scriptEntry.setFinished(true);
                break;
            }
            case ROTATE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                if (angle == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Missing angle argument!");
                    return;
                }
                Runnable rotateRunnable = () -> {
                    int ang;
                    for (ang = angle.asInt(); ang < 0; ang = 360 + ang) {
                    }
                    while (ang > 360) {
                        ang -= 360;
                    }
                    while (ang > 0) {
                        ang -= 90;
                        schematics.get(name.asString().toUpperCase()).rotateOne();
                    }
                    Bukkit.getScheduler().runTask((Plugin)DenizenAPI.getCurrentInstance(), () -> scriptEntry.setFinished(true));
                };
                if (delayed != null && delayed.asBoolean()) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)DenizenAPI.getCurrentInstance(), rotateRunnable);
                    break;
                }
                scriptEntry.setFinished(true);
                rotateRunnable.run();
                break;
            }
            case FLIP_X: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.get(name.asString().toUpperCase()).flipX();
                scriptEntry.setFinished(true);
                break;
            }
            case FLIP_Y: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.get(name.asString().toUpperCase()).flipY();
                scriptEntry.setFinished(true);
                break;
            }
            case FLIP_Z: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.get(name.asString().toUpperCase()).flipZ();
                scriptEntry.setFinished(true);
                break;
            }
            case PASTE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                if (location == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Missing location argument!");
                    return;
                }
                try {
                    BlockSet.InputParams input = new BlockSet.InputParams();
                    input.centerLocation = location;
                    input.noAir = noair != null && noair.asBoolean();
                    input.fakeTo = fakeTo;
                    if (fakeDuration == null) {
                        fakeDuration = new DurationTag(0);
                    }
                    input.fakeDuration = fakeDuration;
                    if (mask != null) {
                        input.mask = new HashSet();
                        for (MaterialTag material : mask) {
                            input.mask.add(material.getMaterial());
                        }
                    }
                    if (delayed != null && delayed.asBoolean()) {
                        schematics.get(name.asString().toUpperCase()).setBlocksDelayed(new Runnable(){

                            @Override
                            public void run() {
                                scriptEntry.setFinished(true);
                            }
                        }, input);
                        break;
                    }
                    scriptEntry.setFinished(true);
                    schematics.get(name.asString().toUpperCase()).setBlocks(input);
                    break;
                }
                catch (Exception ex) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Exception pasting schematic file " + name.asString() + ".");
                    Debug.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
            case SAVE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                CuboidBlockSet set = schematics.get(name.asString().toUpperCase());
                String directory = URLDecoder.decode(System.getProperty("user.dir"));
                String extension = NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13) ? ".schem" : ".schematic";
                File f = new File(directory + "/plugins/Denizen/schematics/" + fname + extension);
                if (!Utilities.canWriteToFile(f)) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Cannot edit that file!");
                    return;
                }
                Runnable saveRunnable = () -> {
                    try {
                        f.getParentFile().mkdirs();
                        FileOutputStream fs = new FileOutputStream(f);
                        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
                            SpongeSchematicHelper.saveToSpongeStream(set, fs);
                        } else {
                            MCEditSchematicHelper.saveMCEditFormatToStream(set, fs);
                        }
                        fs.flush();
                        fs.close();
                        Bukkit.getScheduler().runTask((Plugin)DenizenAPI.getCurrentInstance(), () -> scriptEntry.setFinished(true));
                    }
                    catch (Exception ex) {
                        Bukkit.getScheduler().runTask((Plugin)DenizenAPI.getCurrentInstance(), () -> {
                            Debug.echoError(scriptEntry.getResidingQueue(), "Error saving schematic file " + fname + ".");
                            Debug.echoError(scriptEntry.getResidingQueue(), ex);
                        });
                        return;
                    }
                };
                if (delayed != null && delayed.asBoolean()) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)DenizenAPI.getCurrentInstance(), saveRunnable);
                    break;
                }
                scriptEntry.setFinished(true);
                saveRunnable.run();
                break;
            }
        }
    }

    public void schematicTags(ReplaceableTagEvent event) {
        if (!event.matches("schematic", "schem")) {
            return;
        }
        if (event.matches("schem")) {
            Deprecations.schematicShorthand.warn(event.getContext());
        }
        String id = event.hasNameContext() ? event.getNameContext().toUpperCase() : null;
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("list")) {
            event.setReplaced(new ListTag(schematics.keySet()).getAttribute(attribute.fulfill(1)));
        }
        if (id == null) {
            return;
        }
        if (!schematics.containsKey(id)) {
            if (attribute.startsWith("exists")) {
                event.setReplaced(new ElementTag(false).getAttribute(attribute.fulfill(1)));
                return;
            }
            Debug.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Schematic file " + id + " is not loaded.");
            return;
        }
        CuboidBlockSet set = schematics.get(id);
        if (attribute.startsWith("exists")) {
            event.setReplaced(new ElementTag(true).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("height")) {
            event.setReplaced(new ElementTag(set.y_length).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("length")) {
            event.setReplaced(new ElementTag(set.z_height).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("width")) {
            event.setReplaced(new ElementTag(set.x_width).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("block") && attribute.hasContext(1) && LocationTag.matches(attribute.getContext(1))) {
            LocationTag location = LocationTag.valueOf(attribute.getContext(1));
            BlockData block = set.blockAt(location.getX(), location.getY(), location.getZ());
            event.setReplaced(new MaterialTag(block).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("origin")) {
            event.setReplaced(new LocationTag(null, (double)set.center_x, (double)set.center_y, set.center_z).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("blocks")) {
            event.setReplaced(new ElementTag(set.blocks.length).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("cuboid") && attribute.hasContext(1)) {
            LocationTag origin = LocationTag.valueOf(attribute.getContext(1));
            event.setReplaced(set.getCuboid(origin).getAttribute(attribute.fulfill(1)));
            return;
        }
    }

    private static enum Type {
        CREATE,
        LOAD,
        UNLOAD,
        ROTATE,
        PASTE,
        SAVE,
        FLIP_X,
        FLIP_Y,
        FLIP_Z;

    }
}

