/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class Conversion {
    public static List<Color> convertColors(List<ColorTag> colors) {
        ArrayList<Color> newList = new ArrayList<Color>();
        for (ColorTag color : colors) {
            newList.add(color.getColor());
        }
        return newList;
    }

    public static List<ItemStack> convertItems(List<ItemTag> items) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
        for (ItemTag item : items) {
            newList.add(item.getItemStack());
        }
        return newList;
    }

    public static List<Entity> convertEntities(List<EntityTag> entities) {
        ArrayList<Entity> newList = new ArrayList<Entity>();
        for (EntityTag entity : entities) {
            newList.add(entity.getBukkitEntity());
        }
        return newList;
    }

    public static AbstractMap.SimpleEntry<Integer, InventoryTag> getInventory(Argument arg, ScriptEntry scriptEntry) {
        return Conversion.getInventory(arg.getValue(), scriptEntry.context);
    }

    public static AbstractMap.SimpleEntry<Integer, InventoryTag> getInventory(String string, TagContext context) {
        if (InventoryTag.matches(string)) {
            if (context != null) {
                InventoryTag inv = InventoryTag.valueOf(string, context);
                if (inv != null) {
                    return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
                }
            } else {
                InventoryTag inv = InventoryTag.valueOf(string, null);
                if (inv != null) {
                    return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
                }
            }
        } else {
            InventoryTag inv;
            if (string.startsWith("map@")) {
                MapTag map = MapTag.valueOf(string, context);
                int maxSlot = 0;
                for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
                    if (!ArgumentHelper.matchesInteger(entry.getKey().str)) {
                        return null;
                    }
                    int slot = new ElementTag(entry.getKey().str).asInt();
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
                InventoryTag inventory = new InventoryTag(Math.min(54, maxSlot / 9 * 9 + 9));
                for (Map.Entry<StringHolder, ObjectTag> entry : map.map.entrySet()) {
                    int slot = new ElementTag(entry.getKey().str).asInt();
                    ItemTag item = ItemTag.getItemFor(entry.getValue(), context);
                    if (item == null) {
                        if (context != null && !context.debug) continue;
                        Debug.echoError("Not a valid item: '" + entry.getValue() + "'");
                        continue;
                    }
                    inventory.getInventory().setItem(slot - 1, item.getItemStack());
                }
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(maxSlot, inventory);
            }
            if (ListTag.valueOf(string, context).containsObjectsFrom(ItemTag.class)) {
                List<ItemTag> list = ListTag.valueOf(string, context).filter(ItemTag.class, context);
                ItemStack[] items = Conversion.convertItems(list).toArray(new ItemStack[list.size()]);
                InventoryTag inventory = new InventoryTag(Math.min(54, items.length / 9 * 9 + 9));
                inventory.setContents(items);
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(items.length, inventory);
            }
            if (LocationTag.matches(string)) {
                InventoryTag inv2 = LocationTag.valueOf(string).getInventory();
                if (inv2 != null) {
                    return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv2.getContents().length, inv2);
                }
            } else if (EntityTag.matches(string) && (inv = EntityTag.valueOf(string).getInventory()) != null) {
                return new AbstractMap.SimpleEntry<Integer, InventoryTag>(inv.getContents().length, inv);
            }
        }
        return null;
    }
}

