/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.utilities.Utilities;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Location;
import org.bukkit.block.data.type.Bed;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;

public class SleepingTrait
extends Trait {
    @Persist(value="sleeping")
    private boolean sleeping = false;
    @Persist(value="bed location")
    private Location bedLocation = null;

    public void run() {
        if (this.npc == null || this.bedLocation == null) {
            return;
        }
        if (!Utilities.checkLocation((LivingEntity)this.npc.getEntity(), this.bedLocation, 1.0)) {
            this.wakeUp();
        }
    }

    public void onSpawn() {
        if (this.sleeping) {
            this.internalSleepNow();
        }
    }

    public void internalSleepNow() {
        if (this.npc.getEntity() instanceof Villager) {
            if (!((Villager)this.npc.getEntity()).sleep(this.bedLocation.clone())) {
                return;
            }
        } else if (this.bedLocation.getBlock().getBlockData() instanceof Bed) {
            ((Player)this.npc.getEntity()).sleep(this.bedLocation.clone(), true);
        }
        this.sleeping = true;
    }

    public void toSleep() {
        if (this.sleeping) {
            return;
        }
        if (this.bedLocation == null) {
            this.bedLocation = this.npc.getEntity().getLocation().clone();
        }
        this.internalSleepNow();
    }

    public void toSleep(Location location) {
        if (this.sleeping) {
            return;
        }
        this.npc.getEntity().teleport(location.clone().add(0.5, 0.0, 0.5));
        this.bedLocation = location.clone();
        this.internalSleepNow();
    }

    public void wakeUp() {
        if (!this.sleeping) {
            return;
        }
        this.sleeping = false;
        if (this.npc.getEntity() instanceof Villager) {
            ((Villager)this.npc.getEntity()).wakeup();
        } else {
            if (((Player)this.npc.getEntity()).isSleeping()) {
                ((Player)this.npc.getEntity()).wakeup(false);
            }
            PlayerAnimation.STOP_SLEEPING.play((Player)this.npc.getEntity());
        }
        this.bedLocation = null;
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public Location getBed() {
        return this.bedLocation;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.bedLocation == null) {
            return;
        }
        if (event.getBlock().getLocation().equals((Object)this.bedLocation)) {
            event.setCancelled(true);
        }
    }

    public SleepingTrait() {
        super("sleeping");
    }
}

