/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.inventory;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class InventoryContents
implements Property {
    public static final String[] handledMechs = new String[]{"contents"};
    InventoryTag inventory;

    public static boolean describes(ObjectTag inventory) {
        return inventory instanceof InventoryTag;
    }

    public static InventoryContents getFrom(ObjectTag inventory) {
        if (!InventoryContents.describes(inventory)) {
            return null;
        }
        return new InventoryContents((InventoryTag)inventory);
    }

    public InventoryContents(InventoryTag inventory) {
        this.inventory = inventory;
    }

    public ListTag getContents(int simpleOrFull) {
        if (this.inventory.getInventory() == null) {
            return null;
        }
        ListTag contents = new ListTag();
        boolean containsNonAir = false;
        for (ItemStack item : this.inventory.getInventory().getContents()) {
            if (item != null && item.getType() != Material.AIR) {
                containsNonAir = true;
                if (simpleOrFull == 1) {
                    contents.add(new ItemTag(item).identifySimple());
                    continue;
                }
                contents.addObject(new ItemTag(item));
                continue;
            }
            contents.addObject(new ItemTag(Material.AIR));
        }
        if (!containsNonAir) {
            contents.clear();
        } else {
            for (int x = contents.size() - 1; x >= 0 && ((String)contents.get(x)).equals("i@air"); --x) {
                contents.remove(x);
            }
        }
        return contents;
    }

    public ListTag getContentsWithLore(String lore, boolean simple) {
        if (this.inventory.getInventory() == null) {
            return null;
        }
        ListTag contents = new ListTag();
        lore = ChatColor.stripColor((String)lore);
        block0: for (ItemStack item : this.inventory.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
            for (String line : item.getItemMeta().getLore()) {
                if (!ChatColor.stripColor((String)line).equalsIgnoreCase(lore)) continue;
                if (simple) {
                    contents.add(new ItemTag(item).identifySimple());
                    continue block0;
                }
                contents.addObject(new ItemTag(item));
                continue block0;
            }
        }
        return contents;
    }

    @Override
    public String getPropertyString() {
        if (!this.inventory.getIdType().equals("generic") && !this.inventory.isUnique()) {
            return null;
        }
        ListTag contents = this.getContents(0);
        if (contents == null || contents.isEmpty()) {
            return null;
        }
        return contents.identify();
    }

    @Override
    public String getPropertyId() {
        return "contents";
    }

    public static void registerTags() {
        PropertyParser.registerTag("map_slots", (attribute, contents) -> {
            MapTag map = new MapTag();
            ItemStack[] items = contents.inventory.getContents();
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null || items[i].getType() == Material.AIR) continue;
                map.putObject(String.valueOf(i + 1), new ItemTag(items[i]));
            }
            return map;
        }, new String[0]);
        PropertyParser.registerTag("list_contents", (attribute, contents) -> {
            if (attribute.startsWith("simple", 2)) {
                attribute.fulfill(1);
                return contents.getContents(1);
            }
            if (attribute.startsWith("with_lore", 2)) {
                attribute.fulfill(1);
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String lore = attribute.getContext(1);
                attribute.fulfill(1);
                if (attribute.startsWith("simple", 2)) {
                    attribute.fulfill(1);
                    return contents.getContentsWithLore(lore, true);
                }
                return contents.getContentsWithLore(lore, false);
            }
            return contents.getContents(0);
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("contents") && this.inventory.getIdType().equals("generic")) {
            this.inventory.setContents(mechanism.valueAsType(ListTag.class), mechanism.context);
        }
    }
}

