/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemHidden
implements Property {
    public static final String[] handledTags = new String[]{"flags", "hides"};
    public static final String[] handledMechs = new String[]{"flags", "hides"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getType() != Material.AIR;
    }

    public static ItemHidden getFrom(ObjectTag _item) {
        if (!ItemHidden.describes(_item)) {
            return null;
        }
        return new ItemHidden((ItemTag)_item);
    }

    private ItemHidden(ItemTag _item) {
        this.item = _item;
    }

    @Deprecated
    public ListTag flags() {
        ListTag output = new ListTag();
        ItemStack itemStack = this.item.getItemStack();
        if (itemStack.hasItemMeta()) {
            for (ItemFlag flag : itemStack.getItemMeta().getItemFlags()) {
                output.add(flag.name());
            }
        }
        return output;
    }

    public ListTag hides() {
        ListTag output = new ListTag();
        ItemStack itemStack = this.item.getItemStack();
        if (itemStack.hasItemMeta()) {
            for (ItemFlag flag : itemStack.getItemMeta().getItemFlags()) {
                if (flag == ItemFlag.HIDE_POTION_EFFECTS) {
                    output.add("ITEM_DATA");
                    continue;
                }
                output.add(flag.name().substring("HIDE_".length()));
            }
        }
        return output;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("hides")) {
            return this.hides().getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flags")) {
            Deprecations.itemFlagsProperty.warn(attribute.context);
            return this.flags().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ListTag hidden = this.hides();
        if (hidden.size() > 0) {
            return hidden.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "hides";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("flags") || mechanism.matches("hides")) {
            if (mechanism.matches("flags")) {
                Deprecations.itemFlagsProperty.warn(mechanism.context);
            }
            ItemMeta meta = this.item.getItemStack().getItemMeta();
            meta.removeItemFlags(ItemFlag.values());
            ListTag new_hides = mechanism.valueAsType(ListTag.class);
            for (String str : new_hides) {
                if (!(str = str.toUpperCase()).startsWith("HIDE_")) {
                    str = "HIDE_" + str;
                }
                if (str.equals("HIDE_ALL")) {
                    meta.addItemFlags(ItemFlag.values());
                    continue;
                }
                if (str.equals("HIDE_ITEM_DATA")) {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                    continue;
                }
                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)str)});
            }
            this.item.getItemStack().setItemMeta(meta);
        }
    }
}

