/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemPotion
implements Property {
    public static final String[] handledTags = new String[]{"potion_base_type", "potion_base", "has_potion_effect", "potion_effect"};
    public static final String[] handledMechs = new String[]{"potion_effects"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && (((ItemTag)item).getItemStack().getType() == Material.POTION || ((ItemTag)item).getItemStack().getType() == Material.SPLASH_POTION || ((ItemTag)item).getItemStack().getType() == Material.LINGERING_POTION || ((ItemTag)item).getItemStack().getType() == Material.TIPPED_ARROW);
    }

    public static ItemPotion getFrom(ObjectTag _item) {
        if (!ItemPotion.describes(_item)) {
            return null;
        }
        return new ItemPotion((ItemTag)_item);
    }

    private ItemPotion(ItemTag item) {
        this.item = item;
    }

    public static String stringifyEffect(PotionEffect effect) {
        StringBuilder sb = new StringBuilder();
        sb.append(effect.getType().getName()).append(",").append(effect.getAmplifier()).append(",").append(effect.getDuration()).append(",").append(effect.isAmbient()).append(",").append(effect.hasParticles()).append(",").append(effect.hasIcon());
        return sb.toString();
    }

    public static PotionEffect parseEffect(String str) {
        ElementTag check;
        String[] d2 = str.split(",");
        PotionEffectType type = PotionEffectType.getByName((String)d2[0].toUpperCase());
        int duration = new ElementTag(d2[2]).asInt();
        int amplifier = new ElementTag(d2[1]).asInt();
        boolean ambient = true;
        boolean particles = true;
        if (d2.length > 3) {
            ambient = new ElementTag(d2[3]).asBoolean();
            particles = new ElementTag(d2[4]).asBoolean();
        }
        Color color = null;
        boolean icon = false;
        if (d2.length > 5 && (check = new ElementTag(d2[5])).isBoolean()) {
            icon = check.asBoolean();
        }
        return NMSHandler.getItemHelper().getPotionEffect(type, duration, amplifier, ambient, particles, color, icon);
    }

    @Override
    public String getPropertyString() {
        if (!this.item.getItemStack().hasItemMeta()) {
            return null;
        }
        if (!(this.item.getItemStack().getItemMeta() instanceof PotionMeta)) {
            return null;
        }
        PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
        ListTag effects = new ListTag();
        effects.add(meta.getBasePotionData().getType() + "," + meta.getBasePotionData().isUpgraded() + "," + meta.getBasePotionData().isExtended() + (meta.hasColor() ? "," + new ColorTag(meta.getColor()).identify().replace(",", "&comma") : ""));
        for (PotionEffect pot : meta.getCustomEffects()) {
            effects.add(ItemPotion.stringifyEffect(pot));
        }
        return effects.identify();
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        boolean has;
        if (attribute == null) {
            return null;
        }
        boolean bl = has = this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta() instanceof PotionMeta && ((PotionMeta)this.item.getItemStack().getItemMeta()).hasCustomEffects();
        if (attribute.startsWith("potion_base_type") && this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta() instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
            return new ElementTag(meta.getBasePotionData().getType().name()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("potion_base") && this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta() instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
            return new ElementTag(meta.getBasePotionData().getType().name() + "," + (meta.getBasePotionData().isUpgraded() ? 2 : 1) + "," + meta.getBasePotionData().isExtended() + "," + (this.item.getItemStack().getType() == Material.SPLASH_POTION) + (meta.hasColor() ? "," + new ColorTag(meta.getColor()).identify() : "")).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_potion_effect")) {
            return new ElementTag(has).getObjectAttribute(attribute.fulfill(1));
        }
        if (has && attribute.startsWith("potion_effect")) {
            int potN;
            PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
            int n = potN = attribute.hasContext(1) ? attribute.getIntContext(1) - 1 : 0;
            if (potN < 0 || potN > meta.getCustomEffects().size()) {
                return null;
            }
            if ((attribute = attribute.fulfill(1)).startsWith("is_splash")) {
                return new ElementTag(this.item.getItemStack().getType() == Material.SPLASH_POTION).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_extended")) {
                return new ElementTag(meta.getBasePotionData().isExtended()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("level")) {
                return new ElementTag(meta.getBasePotionData().isUpgraded() ? 2 : 1).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_ambient")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).isAmbient()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("icon")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).hasIcon()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("has_particles")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).hasParticles()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("duration")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getDuration()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("amplifier")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getAmplifier()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("type")) {
                return new ElementTag(((PotionEffect)meta.getCustomEffects().get(potN)).getType().getName()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("data")) {
                return new ElementTag(0).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(meta.getBasePotionData().getType().name() + "," + (meta.getBasePotionData().isUpgraded() ? 2 : 1) + "," + meta.getBasePotionData().isExtended() + "," + (this.item.getItemStack().getType() == Material.SPLASH_POTION)).getObjectAttribute(attribute);
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String[] data;
        if (mechanism.matches("potion_effects")) {
            data = mechanism.valueAsType(ListTag.class);
            String[] d1 = ((String)data.get(0)).split(",");
            PotionMeta meta = (PotionMeta)this.item.getItemStack().getItemMeta();
            meta.setBasePotionData(new PotionData(PotionType.valueOf((String)d1[0].toUpperCase()), CoreUtilities.equalsIgnoreCase(d1[2], "true"), CoreUtilities.equalsIgnoreCase(d1[1], "true")));
            if (d1.length > 3) {
                meta.setColor(ColorTag.valueOf(d1[3].replace("&comma", ","), mechanism.context).getColor());
            }
            meta.clearCustomEffects();
            for (int i = 1; i < data.size(); ++i) {
                meta.addCustomEffect(ItemPotion.parseEffect((String)data.get(i)), false);
            }
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("potion")) {
            data = mechanism.getValue().asString().split(",", 4);
            if (data.length < 4) {
                if (mechanism.getValue().isInt()) {
                    this.item.getItemStack().setDurability((short)mechanism.getValue().asInt());
                } else {
                    Debug.echoError("Invalid effect format, use name,amplifier,extended,splash.");
                }
            } else {
                PotionType type;
                ElementTag data1 = new ElementTag(data[1]);
                ElementTag data2 = new ElementTag(data[2]);
                ElementTag data3 = new ElementTag(data[3]);
                try {
                    type = PotionType.valueOf((String)data[0].toUpperCase());
                }
                catch (Exception ex) {
                    Debug.echoError("Invalid potion effect type '" + data[0] + "'");
                    return;
                }
                if (!data1.isInt()) {
                    Debug.echoError("Cannot apply effect '" + data[0] + "': '" + data[1] + "' is not a valid integer!");
                    return;
                }
                if (!data2.isBoolean()) {
                    Debug.echoError("Cannot apply effect '" + data[0] + "': '" + data[2] + "' is not a valid boolean!");
                    return;
                }
                if (!data3.isBoolean()) {
                    Debug.echoError("Cannot apply effect '" + data[0] + "': '" + data[3] + "' is not a valid boolean!");
                    return;
                }
                Potion pot = new Potion(type);
                int d1 = data1.asInt();
                if (d1 >= 1 && d1 <= pot.getType().getMaxLevel()) {
                    pot.setLevel(d1);
                }
                if (!pot.getType().isInstant()) {
                    pot.setHasExtendedDuration(data2.asBoolean());
                }
                pot.setSplash(data3.asBoolean());
                this.item.setDurability((short)0);
                pot.apply(this.item.getItemStack());
            }
        }
    }
}

