/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.impl.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_16_R1.BlockPosition;
import net.minecraft.server.v1_16_R1.Chunk;
import net.minecraft.server.v1_16_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R1.ChunkStatus;
import net.minecraft.server.v1_16_R1.EnumSkyBlock;
import net.minecraft.server.v1_16_R1.IChunkAccess;
import net.minecraft.server.v1_16_R1.LightEngine;
import net.minecraft.server.v1_16_R1.LightEngineBlock;
import net.minecraft.server.v1_16_R1.LightEngineThreaded;
import net.minecraft.server.v1_16_R1.NibbleArray;
import net.minecraft.server.v1_16_R1.Packet;
import net.minecraft.server.v1_16_R1.PacketPlayOutBlockChange;
import net.minecraft.server.v1_16_R1.PacketPlayOutLightUpdate;
import net.minecraft.server.v1_16_R1.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_16_R1.block.CraftBlock;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BlockLightImpl
extends BlockLight {
    public static final Field PACKETPLAYOUTLIGHTUPDATE_CHUNKX = (Field)ReflectionHelper.getFields(PacketPlayOutLightUpdate.class).get("a");
    public static final Field PACKETPLAYOUTLIGHTUPDATE_CHUNKZ = (Field)ReflectionHelper.getFields(PacketPlayOutLightUpdate.class).get("b");
    public static final Field PACKETPLAYOUTLIGHTUPDATE_BLOCKLIGHT_BITMASK = (Field)ReflectionHelper.getFields(PacketPlayOutLightUpdate.class).get("d");
    public static final Field PACKETPLAYOUTLIGHTUPDATE_BLOCKLIGHT_DATA = (Field)ReflectionHelper.getFields(PacketPlayOutLightUpdate.class).get("h");
    public static final Field PACKETPLAYOUTBLOCKCHANGE_POSITION = (Field)ReflectionHelper.getFields(PacketPlayOutBlockChange.class).get("a");
    public static final Class LIGHTENGINETHREADED_UPDATE = LightEngineThreaded.class.getDeclaredClasses()[0];
    public static final Object LIGHTENGINETHREADED_UPDATE_PRE;
    public static final MethodHandle LIGHTENGINETHREADED_QUEUERUNNABLE;
    public static boolean doNotCheck;
    public static final Vector[] RELATIVE_CHUNKS;

    public static void enqueueRunnable(Chunk chunk, Runnable runnable) {
        LightEngine lightEngine = chunk.e();
        if (lightEngine instanceof LightEngineThreaded) {
            ChunkCoordIntPair coord = chunk.getPos();
            try {
                LIGHTENGINETHREADED_QUEUERUNNABLE.invoke(lightEngine, coord.x, coord.z, LIGHTENGINETHREADED_UPDATE_PRE, runnable);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        } else {
            runnable.run();
        }
    }

    private BlockLightImpl(Location location, long ticks) {
        super(location, ticks);
    }

    public static BlockLight createLight(Location location, int lightLevel, long ticks) {
        BlockLight blockLight;
        if (lightsByLocation.containsKey(location = location.getBlock().getLocation())) {
            blockLight = (BlockLight)lightsByLocation.get(location);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
                blockLight.removeTask = null;
            }
            if (blockLight.updateTask != null) {
                blockLight.updateTask.cancel();
                blockLight.updateTask = null;
            }
            blockLight.removeLater(ticks);
        } else {
            blockLight = new BlockLightImpl(location, ticks);
            lightsByLocation.put(location, blockLight);
            if (!lightsByChunk.containsKey(blockLight.chunkCoord)) {
                lightsByChunk.put(blockLight.chunkCoord, new ArrayList());
            }
            ((List)lightsByChunk.get(blockLight.chunkCoord)).add(blockLight);
        }
        blockLight.intendedLevel = lightLevel;
        blockLight.update(lightLevel, true);
        return blockLight;
    }

    public static void checkIfLightsBrokenByPacket(PacketPlayOutBlockChange packet, World world) {
        try {
            BlockPosition pos = (BlockPosition)PACKETPLAYOUTBLOCKCHANGE_POSITION.get(packet);
            int chunkX = pos.getX() >> 4;
            int chunkZ = pos.getZ() >> 4;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> {
                Chunk chunk = world.getChunkAt(chunkX, chunkZ);
                boolean any = false;
                for (Vector vec : RELATIVE_CHUNKS) {
                    List lights;
                    IChunkAccess other = world.getChunkAt(chunkX + vec.getBlockX(), chunkZ + vec.getBlockZ(), ChunkStatus.FULL, false);
                    if (!(other instanceof Chunk) || (lights = (List)lightsByChunk.get(((Chunk)other).bukkitChunk)) == null) continue;
                    any = true;
                    for (BlockLight light : lights) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> light.update(light.intendedLevel, false), 1L);
                    }
                }
                if (any) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> BlockLightImpl.sendNearbyChunkUpdates(chunk), 3L);
                }
            }, 1L);
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static void checkIfLightsBrokenByPacket(PacketPlayOutLightUpdate packet, World world) {
        if (doNotCheck) {
            return;
        }
        try {
            int cX = PACKETPLAYOUTLIGHTUPDATE_CHUNKX.getInt(packet);
            int cZ = PACKETPLAYOUTLIGHTUPDATE_CHUNKZ.getInt(packet);
            int bitMask = PACKETPLAYOUTLIGHTUPDATE_BLOCKLIGHT_BITMASK.getInt(packet);
            List blockData = (List)PACKETPLAYOUTLIGHTUPDATE_BLOCKLIGHT_DATA.get(packet);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> {
                IChunkAccess chk = world.getChunkAt(cX, cZ, ChunkStatus.FULL, false);
                if (!(chk instanceof Chunk)) {
                    return;
                }
                List lights = (List)lightsByChunk.get(((Chunk)chk).bukkitChunk);
                if (lights == null) {
                    return;
                }
                boolean any = false;
                for (BlockLight light : lights) {
                    if (!((BlockLightImpl)light).checkIfChangedBy(bitMask, blockData)) continue;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> light.update(light.intendedLevel, false), 1L);
                    any = true;
                }
                if (any) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> BlockLightImpl.sendNearbyChunkUpdates((Chunk)chk), 3L);
                }
            }, 1L);
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean checkIfChangedBy(int bitmask, List<byte[]> data) {
        Location blockLoc = this.block.getLocation();
        int layer = (blockLoc.getBlockY() >> 4) + 1;
        if ((bitmask & 1 << layer) == 0) {
            return false;
        }
        int found = 0;
        for (int i = 0; i < 16; ++i) {
            if ((bitmask & 1 << i) == 0) continue;
            if (i == layer) {
                int z;
                int y;
                int x;
                byte[] blocks = data.get(found);
                NibbleArray arr = new NibbleArray(blocks);
                int level = arr.a(x = blockLoc.getBlockX() - (this.chunkCoord.x << 4), y = blockLoc.getBlockY() % 16, z = blockLoc.getBlockZ() - (this.chunkCoord.z << 4));
                return this.intendedLevel != level;
            }
            ++found;
        }
        return false;
    }

    public static void runResetFor(final Chunk chunk, final BlockPosition pos) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LightEngine lightEngine = chunk.e();
                LightEngineBlock engineBlock = (LightEngineBlock)lightEngine.a(EnumSkyBlock.BLOCK);
                engineBlock.a(pos);
            }
        };
        BlockLightImpl.enqueueRunnable(chunk, runnable);
    }

    public static void runSetFor(final Chunk chunk, final BlockPosition pos, final int level) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LightEngine lightEngine = chunk.e();
                LightEngineBlock engineBlock = (LightEngineBlock)lightEngine.a(EnumSkyBlock.BLOCK);
                engineBlock.a(pos, level);
            }
        };
        BlockLightImpl.enqueueRunnable(chunk, runnable);
    }

    public void reset(boolean updateChunk) {
        BlockLightImpl.runResetFor(((CraftChunk)this.getChunk()).getHandle(), ((CraftBlock)this.block).getPosition());
        if (updateChunk) {
            this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), this::sendNearbyChunkUpdates, 1L);
        }
    }

    public void update(int lightLevel, boolean updateChunk) {
        BlockLightImpl.runResetFor(((CraftChunk)this.getChunk()).getHandle(), ((CraftBlock)this.block).getPosition());
        this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), () -> {
            this.updateTask = null;
            BlockLightImpl.runSetFor(((CraftChunk)this.chunk).getHandle(), ((CraftBlock)this.block).getPosition(), lightLevel);
            if (updateChunk) {
                this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), this::sendNearbyChunkUpdates, 1L);
            }
        }, 1L);
    }

    public void sendNearbyChunkUpdates() {
        BlockLightImpl.sendNearbyChunkUpdates(((CraftChunk)this.getChunk()).getHandle());
    }

    public static void sendNearbyChunkUpdates(Chunk chunk) {
        ChunkCoordIntPair pos = chunk.getPos();
        for (Vector vec : RELATIVE_CHUNKS) {
            IChunkAccess other = chunk.getWorld().getChunkAt(pos.x + vec.getBlockX(), pos.z + vec.getBlockZ(), ChunkStatus.FULL, false);
            if (!(other instanceof Chunk)) continue;
            BlockLightImpl.sendSingleChunkUpdate((Chunk)other);
        }
    }

    public static void sendSingleChunkUpdate(Chunk chunk) {
        doNotCheck = true;
        LightEngine lightEngine = chunk.e();
        ChunkCoordIntPair pos = chunk.getPos();
        PacketPlayOutLightUpdate packet = new PacketPlayOutLightUpdate(pos, lightEngine, true);
        chunk.world.getChunkProvider().playerChunkMap.a(pos, false).forEach(player -> player.playerConnection.sendPacket((Packet)packet));
        doNotCheck = false;
    }

    static {
        Object preObj = null;
        try {
            preObj = ((Field)ReflectionHelper.getFields((Class)LIGHTENGINETHREADED_UPDATE).get("PRE_UPDATE")).get(null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        LIGHTENGINETHREADED_UPDATE_PRE = preObj;
        LIGHTENGINETHREADED_QUEUERUNNABLE = ReflectionHelper.getMethodHandle(LightEngineThreaded.class, (String)"a", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, LIGHTENGINETHREADED_UPDATE, Runnable.class});
        doNotCheck = false;
        RELATIVE_CHUNKS = new Vector[]{new Vector(0, 0, 0), new Vector(-1, 0, 0), new Vector(1, 0, 0), new Vector(0, 0, -1), new Vector(0, 0, 1), new Vector(-1, 0, -1), new Vector(-1, 0, 1), new Vector(1, 0, -1), new Vector(1, 0, 1)};
    }
}

