/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class BukkitScriptEvent
extends ScriptEvent {
    public static HashSet<String> specialEntityMatchables = new HashSet<String>(Arrays.asList("player", "entity", "npc", "vehicle", "fish", "projectile", "hanging"));
    private static Field REGISTERED_LISTENER_EXECUTOR_FIELD;
    public HashMap<EventPriority, BukkitScriptEvent> priorityHandlers;
    public List<Map.Entry<RegisteredListener, HandlerList>> registeredHandlers;
    public Event currentEvent = null;

    public boolean couldMatchInArea(String lower) {
        String next;
        int index = CoreUtilities.split(lower, ' ').indexOf("in");
        if (index == -1) {
            return true;
        }
        String in = CoreUtilities.getXthArg(index + 1, lower);
        if (InventoryTag.matches(in) || CoreUtilities.equalsIgnoreCase(in, "inventory") || BukkitScriptEvent.isAdvancedMatchable(in)) {
            return false;
        }
        return !in.equals("notable") && !in.equals("noted") || (next = CoreUtilities.getXthArg(index + 2, lower)).equals("cuboid") || next.equals("ellipsoid");
    }

    public boolean exactMatchesEnum(String text, Enum<?>[] enumVals) {
        for (Enum<?> val : enumVals) {
            if (!CoreUtilities.equalsIgnoreCase(val.name(), text)) continue;
            return true;
        }
        return false;
    }

    public boolean couldMatchEnum(String text, Enum<?>[] enumVals) {
        if (this.exactMatchesEnum(text, enumVals)) {
            return true;
        }
        return this.genericCouldMatchChecks(text, t -> this.couldMatchEnum((String)t, enumVals));
    }

    public boolean couldMatchInventory(String text) {
        if (text.equals("inventory")) {
            return true;
        }
        if (InventoryTag.matches(text)) {
            return true;
        }
        return this.genericCouldMatchChecks(text, this::couldMatchInventory);
    }

    public boolean couldMatchEntity(String text) {
        if (specialEntityMatchables.contains(text)) {
            return true;
        }
        if (EntityTag.matches(text)) {
            return true;
        }
        return this.genericCouldMatchChecks(text, this::couldMatchEntity);
    }

    public boolean exactMatchesVehicle(String text) {
        if (text.equals("vehicle")) {
            return true;
        }
        if (specialEntityMatchables.contains(text)) {
            return false;
        }
        if (EntityTag.matches(text)) {
            EntityTag entity = EntityTag.valueOf(text, CoreUtilities.noDebugContext);
            if (entity == null) {
                return false;
            }
            return Vehicle.class.isAssignableFrom(entity.getEntityType().getBukkitEntityType().getEntityClass());
        }
        return false;
    }

    public boolean couldMatchVehicle(String text) {
        if (this.exactMatchesVehicle(text)) {
            return true;
        }
        return this.genericCouldMatchChecks(text, this::couldMatchVehicle);
    }

    public boolean couldMatchBlock(String text) {
        if (text.equals("block") || text.equals("material")) {
            return true;
        }
        if (text.equals("item")) {
            return false;
        }
        if (MaterialTag.matches(text)) {
            MaterialTag mat = MaterialTag.valueOf(text, CoreUtilities.noDebugContext);
            return mat != null && mat.getMaterial().isBlock();
        }
        return this.genericCouldMatchChecks(text, this::couldMatchBlock);
    }

    public boolean couldMatchItem(String text) {
        if (text.equals("item")) {
            return true;
        }
        if (MaterialTag.matches(text)) {
            MaterialTag mat = MaterialTag.valueOf(text, CoreUtilities.noDebugContext);
            return mat != null && mat.getMaterial().isItem();
        }
        if (ItemTag.matches(text)) {
            return true;
        }
        return this.genericCouldMatchChecks(text, this::couldMatchItem);
    }

    public boolean genericCouldMatchChecks(String text, Function<String, Boolean> checkType) {
        if (CoreUtilities.contains(text, '*')) {
            return true;
        }
        if (text.startsWith("regex:")) {
            return true;
        }
        if (CoreUtilities.contains(text, '|')) {
            for (String subMatch : text.split("\\|")) {
                if (checkType.apply(subMatch).booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean nonSwitchWithCheck(ScriptEvent.ScriptPath path, ItemTag held) {
        int index;
        for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals("with"); ++index) {
        }
        if (index >= path.eventArgsLower.length) {
            return true;
        }
        String with = path.eventArgLowerAt(index + 1);
        return with == null || held != null && this.tryItem(held, with);
    }

    public BukkitTagContext getTagContext(ScriptEvent.ScriptPath path) {
        BukkitTagContext context = (BukkitTagContext)this.getScriptEntryData().getTagContext().clone();
        context.script = new ScriptTag(path.container);
        context.debug = path.container.shouldDebug();
        return context;
    }

    public static Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException var3) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return BukkitScriptEvent.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    public static HandlerList getEventListeners(Class<? extends Event> type) {
        try {
            Method method = BukkitScriptEvent.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception var3) {
            throw new IllegalPluginAccessException(var3.toString());
        }
    }

    public static EventExecutor getExecutor(RegisteredListener listener) {
        try {
            return (EventExecutor)REGISTERED_LISTENER_EXECUTOR_FIELD.get(listener);
        }
        catch (IllegalAccessException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public void fire() {
        if (!Bukkit.isPrimaryThread()) {
            if (Debug.verbose) {
                Debug.log("Event is firing async: " + this.getName());
            }
            final BukkitScriptEvent altEvent = (BukkitScriptEvent)this.clone();
            new BukkitRunnable(){

                public void run() {
                    altEvent.fire();
                }
            }.runTask((Plugin)DenizenAPI.getCurrentInstance());
            return;
        }
        super.fire();
    }

    @Override
    public void cancellationChanged() {
        if (this.currentEvent instanceof Cancellable) {
            ((Cancellable)this.currentEvent).setCancelled(this.cancelled);
        }
        super.cancellationChanged();
    }

    public void fire(Event event) {
        this.currentEvent = event;
        this.cancelled = event instanceof Cancellable ? ((Cancellable)event).isCancelled() : false;
        this.fire();
    }

    @Override
    public void destroy() {
        if (this.priorityHandlers != null) {
            for (BukkitScriptEvent bukkitScriptEvent : this.priorityHandlers.values()) {
                bukkitScriptEvent.destroy();
            }
            this.priorityHandlers = null;
        }
        if (this.registeredHandlers != null) {
            for (Map.Entry entry : this.registeredHandlers) {
                ((HandlerList)entry.getValue()).unregister((RegisteredListener)entry.getKey());
            }
            this.registeredHandlers = null;
        }
    }

    @Override
    public void init() {
        if (this instanceof Listener) {
            this.initListener((Listener)this);
        }
    }

    public void initListener(Listener listener) {
        if (this.priorityHandlers == null) {
            this.priorityHandlers = new HashMap();
        }
        for (ScriptEvent.ScriptPath path : new ArrayList(this.eventPaths)) {
            String bukkitPriority = path.switches.get("bukkit_priority");
            if (bukkitPriority == null) continue;
            try {
                EventPriority priority = EventPriority.valueOf((String)bukkitPriority.toUpperCase());
                BukkitScriptEvent handler = this.priorityHandlers.get(priority);
                if (handler == null) {
                    handler = (BukkitScriptEvent)this.clone();
                    handler.eventPaths = new ArrayList();
                    handler.priorityHandlers = null;
                    handler.registeredHandlers = null;
                    this.priorityHandlers.put(priority, handler);
                    handler.initForPriority(priority, (Listener)handler);
                }
                handler.eventPaths.add(path);
                this.eventPaths.remove(path);
            }
            catch (IllegalArgumentException ex) {
                Debug.echoError("Invalid 'bukkit_priority' switch for event '" + path.event + "' in script '" + path.container.getName() + "'.");
                Debug.echoError(ex);
            }
        }
        if (!this.eventPaths.isEmpty()) {
            this.initForPriority(EventPriority.NORMAL, listener);
        }
    }

    public void initForPriority(EventPriority priority, Listener listener) {
        if (this.registeredHandlers == null) {
            this.registeredHandlers = new ArrayList<Map.Entry<RegisteredListener, HandlerList>>();
        }
        Denizen plugin = DenizenAPI.getCurrentInstance();
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(listener, (Plugin)plugin).entrySet()) {
            for (RegisteredListener registeredListener : (Set)entry.getValue()) {
                RegisteredListener newListener = new RegisteredListener(listener, BukkitScriptEvent.getExecutor(registeredListener), priority, (Plugin)plugin, false);
                HandlerList handlers = BukkitScriptEvent.getEventListeners(BukkitScriptEvent.getRegistrationClass((Class)entry.getKey()));
                handlers.register(newListener);
                this.registeredHandlers.add(new AbstractMap.SimpleEntry<RegisteredListener, HandlerList>(newListener, handlers));
            }
        }
    }

    public boolean runInCheck(ScriptEvent.ScriptPath path, Location location) {
        return this.runInCheck(path, location, "in");
    }

    public boolean runInCheck(ScriptEvent.ScriptPath path, Location location, String innote) {
        String inputText = path.switches.get(innote);
        if (inputText == null) {
            int index;
            for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals(innote); ++index) {
            }
            if (index >= path.eventArgsLower.length) {
                return true;
            }
            if (location == null) {
                return false;
            }
            Deprecations.inAreaSwitchFormat.warn();
            inputText = path.eventArgLowerAt(index + 1);
            if (inputText.equals("notable") || inputText.equals("noted")) {
                String subit = path.eventArgLowerAt(index + 2);
                if (subit.equals("cuboid")) {
                    return CuboidTag.getNotableCuboidsContaining(location).size() > 0;
                }
                if (subit.equals("ellipsoid")) {
                    return EllipsoidTag.getNotableEllipsoidsContaining(location).size() > 0;
                }
                Debug.echoError("Invalid event 'IN ...' check [" + this.getName() + "] ('in notable ???'): '" + path.event + "' for " + path.container.getName());
                return false;
            }
        }
        if (location == null) {
            return false;
        }
        String lower = CoreUtilities.toLowerCase(inputText);
        if (lower.equals("cuboid")) {
            return CuboidTag.getNotableCuboidsContaining(location).size() > 0;
        }
        if (lower.equals("ellipsoid")) {
            return EllipsoidTag.getNotableEllipsoidsContaining(location).size() > 0;
        }
        if (WorldTag.matches(inputText)) {
            return CoreUtilities.equalsIgnoreCase(location.getWorld().getName(), lower);
        }
        if (CuboidTag.matches(inputText)) {
            CuboidTag cuboid = CuboidTag.valueOf(inputText, this.getTagContext(path));
            if (cuboid == null || !cuboid.isUnique()) {
                Debug.echoError("Invalid event 'in:<area>' switch [" + this.getName() + "] (invalid cuboid): '" + path.event + "' for " + path.container.getName());
                return false;
            }
            return cuboid.isInsideCuboid(location);
        }
        if (EllipsoidTag.matches(inputText)) {
            EllipsoidTag ellipsoid = EllipsoidTag.valueOf(inputText, this.getTagContext(path));
            if (ellipsoid == null || !ellipsoid.isUnique()) {
                Debug.echoError("Invalid event 'in:<area>' switch [" + this.getName() + "] (invalid ellipsoid): '" + path.event + "' for " + path.container.getName());
                return false;
            }
            return ellipsoid.contains(location);
        }
        if (BukkitScriptEvent.isAdvancedMatchable(lower)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(lower);
            for (CuboidTag cuboid : NotableManager.getAllType(CuboidTag.class)) {
                if (!cuboid.isInsideCuboid(location) || !matcher.doesMatch(cuboid.noteName)) continue;
                return true;
            }
            for (EllipsoidTag ellipsoid : NotableManager.getAllType(EllipsoidTag.class)) {
                if (!ellipsoid.contains(location) || !matcher.doesMatch(ellipsoid.noteName)) continue;
                return true;
            }
            for (World world : Bukkit.getWorlds()) {
                if (!matcher.doesMatch(CoreUtilities.toLowerCase(world.getName()))) continue;
                return true;
            }
            return false;
        }
        Debug.echoError("Invalid event 'in:<area>' switch [" + this.getName() + "] ('in:???') (did you make a typo, or forget to make a notable by that name?): '" + path.event + "' for " + path.container.getName());
        return false;
    }

    public boolean runWithCheck(ScriptEvent.ScriptPath path, ItemTag held) {
        String with = path.switches.get("with");
        if (with != null) {
            if (CoreUtilities.equalsIgnoreCase(with, "item")) {
                return true;
            }
            if (held == null || !this.tryItem(held, with)) {
                return false;
            }
        }
        return true;
    }

    public boolean runFlaggedCheck(ScriptEvent.ScriptPath path, PlayerTag player) {
        return this.runFlaggedCheck(path, "flagged", player);
    }

    public boolean runFlaggedCheck(ScriptEvent.ScriptPath path, String switchName, PlayerTag player) {
        String flagged = path.switches.get(switchName);
        if (flagged == null) {
            return true;
        }
        if (player == null) {
            return false;
        }
        for (String flag : CoreUtilities.split(flagged, '|')) {
            if (FlagManager.playerHasFlag(player, flag)) continue;
            return false;
        }
        return true;
    }

    public boolean runPermissionCheck(ScriptEvent.ScriptPath path, PlayerTag player) {
        return this.runPermissionCheck(path, "permission", player);
    }

    public boolean runPermissionCheck(ScriptEvent.ScriptPath path, String switchName, PlayerTag player) {
        String perm = path.switches.get(switchName);
        if (perm == null) {
            return true;
        }
        if (player == null || !player.isOnline()) {
            return false;
        }
        for (String permName : CoreUtilities.split(perm, '|')) {
            if (player.getPlayerEntity().hasPermission(permName)) continue;
            return false;
        }
        return true;
    }

    public boolean runAutomaticPlayerSwitches(ScriptEvent.ScriptPath path) {
        if (!path.switches.containsKey("flagged") && !path.switches.containsKey("permission")) {
            return true;
        }
        BukkitScriptEntryData data = (BukkitScriptEntryData)this.getScriptEntryData();
        if (!data.hasPlayer()) {
            return true;
        }
        if (!this.runFlaggedCheck(path, data.getPlayer())) {
            return false;
        }
        return this.runPermissionCheck(path, data.getPlayer());
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return this.runAutomaticPlayerSwitches(path);
    }

    public boolean tryInventory(InventoryTag inv, String comparedto) {
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("inventory")) {
            return true;
        }
        if (comparedto.equals("notable") || comparedto.equals("note")) {
            return NotableManager.isSaved(inv);
        }
        ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(comparedto);
        if (matcher.doesMatch(inv.getInventoryType().name())) {
            return true;
        }
        if (matcher.doesMatch(inv.getIdType())) {
            return true;
        }
        if (matcher.doesMatch(inv.getIdHolder())) {
            return true;
        }
        if (inv.scriptName != null && matcher.doesMatch(inv.scriptName)) {
            return true;
        }
        String notedId = NotableManager.getSavedId(inv);
        return notedId != null && matcher.doesMatch(notedId);
    }

    public boolean tryItem(ItemTag item, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || item == null) {
            return false;
        }
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("item")) {
            return true;
        }
        if (comparedto.equals("potion") && CoreUtilities.toLowerCase(item.getItemStack().getType().name()).contains("potion")) {
            return true;
        }
        ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(comparedto);
        return item.isItemscript() ? matcher.doesMatch(item.getScriptName()) : matcher.doesMatch(item.getMaterialName());
    }

    public boolean tryMaterial(MaterialTag mat, String comparedto) {
        ScriptEvent.MatchHelper matcher;
        if (comparedto == null || comparedto.isEmpty() || mat == null) {
            return false;
        }
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("block") || comparedto.equals("material")) {
            return true;
        }
        MaterialTag quickOf = MaterialTag.quickOfNamed(comparedto);
        if (quickOf != null) {
            if (quickOf.getMaterial() != mat.getMaterial()) {
                return false;
            }
            if (quickOf.equals(mat)) {
                return true;
            }
        }
        if ((matcher = BukkitScriptEvent.createMatcher(comparedto)).doesMatch(mat.realName())) {
            return true;
        }
        if (matcher.doesMatch(mat.identifyNoIdentifier())) {
            return true;
        }
        if (matcher.doesMatch(mat.identifySimpleNoIdentifier())) {
            return true;
        }
        return matcher.doesMatch(mat.identifyFullNoIdentifier());
    }

    public boolean tryEntity(EntityTag entity, String comparedto) {
        if (comparedto == null || comparedto.isEmpty() || entity == null) {
            return false;
        }
        Entity bEntity = entity.getBukkitEntity();
        if ((comparedto = CoreUtilities.toLowerCase(comparedto)).equals("entity")) {
            return true;
        }
        if (comparedto.equals("npc")) {
            return entity.isCitizensNPC();
        }
        if (comparedto.equals("player")) {
            return entity.isPlayer();
        }
        if (comparedto.equals("vehicle")) {
            return bEntity instanceof Vehicle;
        }
        if (comparedto.equals("fish")) {
            return bEntity instanceof Fish;
        }
        if (comparedto.equals("projectile")) {
            return bEntity instanceof Projectile;
        }
        if (comparedto.equals("hanging")) {
            return bEntity instanceof Hanging;
        }
        ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(comparedto);
        if (entity.getEntityScript() != null && matcher.doesMatch(entity.getEntityScript())) {
            return true;
        }
        return matcher.doesMatch(entity.getEntityType().getLowercaseName());
    }

    static {
        try {
            REGISTERED_LISTENER_EXECUTOR_FIELD = RegisteredListener.class.getDeclaredField("executor");
            REGISTERED_LISTENER_EXECUTOR_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Debug.echoError(ex);
        }
    }
}

