/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.SittingTrait;
import com.denizenscript.denizen.npc.traits.SleepingTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Villager;

public class StandCommand
extends AbstractCommand {
    public StandCommand() {
        this.setName("stand");
        this.setSyntax("stand");
        this.setRequiredArguments(0, 0);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Entity entity;
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (!(npc.getEntity() instanceof Player || npc.getEntity() instanceof Sittable || npc.getEntity() instanceof Villager)) {
            Debug.echoError("Entities of type " + npc.getEntityType().getName() + " cannot sit or sleep.");
            return;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("npc", Utilities.getEntryNPC(scriptEntry)));
        }
        if ((entity = npc.getEntity()) instanceof Sittable) {
            ((Sittable)entity).setSitting(false);
        } else {
            Trait trait;
            if (npc.getCitizen().hasTrait(SittingTrait.class)) {
                trait = (SittingTrait)npc.getCitizen().getTrait(SittingTrait.class);
                trait.stand();
                npc.getCitizen().removeTrait(SittingTrait.class);
            }
            if (npc.getCitizen().hasTrait(SleepingTrait.class)) {
                trait = (SleepingTrait)npc.getCitizen().getTrait(SleepingTrait.class);
                trait.wakeUp();
                npc.getCitizen().removeTrait(SleepingTrait.class);
            }
        }
    }
}

