/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Set;

public class EntityScriptContainer
extends ScriptContainer {
    public EntityScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        this.canRunScripts = false;
    }

    public EntityTag getEntityFrom() {
        return this.getEntityFrom(null, null);
    }

    public EntityTag getEntityFrom(PlayerTag player, NPCTag npc) {
        EntityTag entity;
        try {
            BukkitTagContext context = new BukkitTagContext(player, npc, new ScriptTag(this));
            if (!this.contains("entity_type")) {
                throw new Exception("Missing entity_type argument!");
            }
            String entityType = TagManager.tag(this.getString("entity_type", ""), context);
            entity = EntityTag.valueOf(entityType, context);
            Set<StringHolder> strings = this.getConfigurationSection("").getKeys(false);
            for (StringHolder string : strings) {
                if (string.low.equals("entity_type") || string.low.equals("type") || string.low.equals("debug") || string.low.equals("custom")) continue;
                String value = TagManager.tag(this.getString(string.low, ""), context);
                entity.safeAdjust(new Mechanism(new ElementTag(string.low), new ElementTag(value), context));
            }
            if (entity == null || entity.isUnique()) {
                return null;
            }
            entity.setEntityScript(this.getName());
        }
        catch (Exception e) {
            Debug.echoError("Woah! An exception has been called with this entity script!");
            Debug.echoError(e);
            entity = null;
        }
        return entity;
    }
}

