/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PreEntitySpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PreEntitySpawnScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    public PreCreatureSpawnEvent event;

    public PreEntitySpawnScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("prespawns")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(0));
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("because") && !path.eventArgLowerAt(3).equalsIgnoreCase(this.event.getReason().name())) {
            return false;
        }
        if (!this.runInCheck(path, (Location)this.location)) {
            return false;
        }
        return super.matches(path);
    }

    public String getName() {
        return "PreEntitySpawn";
    }

    public void cancellationChanged() {
        this.event.setShouldAbortSpawn(this.cancelled);
        super.cancellationChanged();
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("reason")) {
            return new ElementTag(this.event.getReason().name());
        }
        if (name.equals("spawner_location") && this.event instanceof PreSpawnerSpawnEvent) {
            return new LocationTag(((PreSpawnerSpawnEvent)this.event).getSpawnerLocation());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPreCreatureSpawn(PreCreatureSpawnEvent event) {
        this.entity = new EntityTag(event.getType());
        this.location = new LocationTag(event.getSpawnLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

