/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.flags;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.core.FlagSmartEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.Warning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;

public class FlagManager {
    public static Warning listFlagsTagWarning = new SlowWarning("The list_flags tag is meant for testing/debugging only. Do not use it in scripts (ignore this warning if using for testing reasons).");
    private Denizen denizen;

    public FlagManager(Denizen denizen) {
        this.denizen = denizen;
    }

    public static boolean playerHasFlag(PlayerTag player, String flagName) {
        if (player == null || flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(player, flagName).size() > 0;
    }

    public static boolean entityHasFlag(EntityTag entity, String flagName) {
        if (entity == null || flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getEntityFlag(entity, flagName).size() > 0;
    }

    public static boolean npcHasFlag(NPCTag npc, String flagName) {
        if (npc == null || flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(npc.getId(), flagName).size() > 0;
    }

    public static boolean serverHasFlag(String flagName) {
        if (flagName == null) {
            return false;
        }
        return DenizenAPI.getCurrentInstance().flagManager().getGlobalFlag(flagName).size() > 0;
    }

    public static void clearNPCFlags(int npcid) {
        DenizenAPI.getCurrentInstance().getSaves().set("NPCs." + npcid, null);
    }

    public static void clearEntityFlags(EntityTag entity) {
        DenizenAPI.getCurrentInstance().getSaves().set("Entities." + entity.getSaveName(), null);
    }

    public Flag getNPCFlag(int npcid, String flagName) {
        return new Flag("NPCs." + npcid + ".Flags." + flagName.toUpperCase(), flagName, "n@" + npcid);
    }

    public Flag getGlobalFlag(String flagName) {
        return new Flag("Global.Flags." + flagName.toUpperCase(), flagName, "SERVER");
    }

    public Flag getPlayerFlag(PlayerTag player, String flagName) {
        if (player == null) {
            return new Flag("players.00.UNKNOWN.Flags." + flagName.toUpperCase(), flagName, "p@null");
        }
        return new Flag("Players." + player.getSaveName() + ".Flags." + flagName.toUpperCase(), flagName, player.identify());
    }

    public Flag getEntityFlag(EntityTag entity, String flagName) {
        if (entity == null) {
            return new Flag("Entities.00.UNKNOWN.Flags." + flagName.toUpperCase(), flagName, "e@null");
        }
        return new Flag("Entities." + entity.getSaveName() + ".Flags." + flagName.toUpperCase(), flagName, entity.identify());
    }

    public Set<String> listNPCFlags(int npcid) {
        ConfigurationSection section = this.denizen.getSaves().getConfigurationSection("NPCs." + npcid + ".Flags");
        return section != null ? this._filterExpirations(section.getValues(true).keySet()) : null;
    }

    public void shrinkGlobalFlags(Collection<String> set) {
        for (String str : new HashSet<String>(set)) {
            if (FlagManager.serverHasFlag(str)) continue;
            set.remove(str);
        }
    }

    public void shrinkPlayerFlags(PlayerTag player, Collection<String> set) {
        for (String str : new HashSet<String>(set)) {
            if (FlagManager.playerHasFlag(player, str)) continue;
            set.remove(str);
        }
    }

    public void shrinkEntityFlags(EntityTag entity, Collection<String> set) {
        for (String str : new HashSet<String>(set)) {
            if (FlagManager.entityHasFlag(entity, str)) continue;
            set.remove(str);
        }
    }

    public Set<String> listGlobalFlags() {
        ConfigurationSection section = this.denizen.getSaves().getConfigurationSection("Global.Flags");
        return section != null ? this._filterExpirations(section.getValues(true).keySet()) : null;
    }

    public Set<String> listPlayerFlags(PlayerTag player) {
        ConfigurationSection section = this.denizen.getSaves().getConfigurationSection("Players." + player.getSaveName() + ".Flags");
        return section != null ? this._filterExpirations(section.getValues(true).keySet()) : null;
    }

    public Set<String> listEntityFlags(EntityTag entity) {
        ConfigurationSection section = this.denizen.getSaves().getConfigurationSection("Entities." + entity.getSaveName() + ".Flags");
        return section != null ? this._filterExpirations(section.getValues(true).keySet()) : null;
    }

    public Set<String> _filterExpirations(Set<String> flagKeys) {
        Iterator<String> iter = flagKeys.iterator();
        while (iter.hasNext()) {
            if (!iter.next().endsWith("-expiration")) continue;
            iter.remove();
        }
        return flagKeys;
    }

    public class Value {
        private String firstValue;
        private List<String> values;
        private int index;
        private int size;

        public Value() {
            this.size = 0;
            this.index = 0;
        }

        public void mustBeList() {
            if (this.values == null) {
                this.values = new ArrayList<String>();
                if (this.size != 0) {
                    this.values.add(this.firstValue);
                }
            }
        }

        public void fixSize() {
            if (this.values != null) {
                this.size = this.values.size();
            }
        }

        public Value(String oneValue) {
            this.firstValue = oneValue;
            this.size = 1;
            this.index = 1;
        }

        public Value(List<String> values) {
            this.values = values;
            if (values == null) {
                this.size = 0;
                this.index = 0;
            } else {
                this.size = values.size();
                this.index = values.size() - 1;
            }
        }

        private String getValue() {
            if (this.values == null) {
                if (this.size == 0) {
                    return "";
                }
                if (this.index == 0) {
                    return this.firstValue;
                }
                return "";
            }
            return this.values.get(this.index);
        }

        private void adjustIndex() {
            if (this.index < 0) {
                this.index = this.size() - 1;
            }
        }

        public boolean asBoolean() {
            return !this.getValue().equalsIgnoreCase("false");
        }

        public double asDouble() {
            try {
                return Double.valueOf(this.getValue());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        public int asInteger() {
            try {
                return Double.valueOf(this.getValue()).intValue();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        public String asCommaSeparatedList() {
            if (this.values == null) {
                if (this.size == 0) {
                    return "";
                }
                return this.firstValue;
            }
            return String.join((CharSequence)", ", this.values);
        }

        public ListTag asList() {
            if (this.values == null) {
                ListTag toReturn = new ListTag();
                if (this.size != 0) {
                    toReturn.add(this.firstValue);
                }
                return toReturn;
            }
            return new ListTag(this.values);
        }

        public String asString() {
            return this.getValue();
        }

        public int asSize() {
            return this.size;
        }

        private Value get(int i) {
            this.index = i - 1;
            this.adjustIndex();
            return this;
        }

        public boolean isEmpty() {
            if (this.size == 0) {
                return true;
            }
            if (this.index >= this.size) {
                return true;
            }
            return this.getValue().equals("");
        }

        public int size() {
            return this.size;
        }
    }

    public class Flag {
        private Value value;
        private String flagPath;
        private String flagName;
        private String flagOwner;
        private long expiration = -1L;
        private boolean valid = true;

        Flag(String flagPath, String flagName, String flagOwner) {
            this.flagPath = flagPath;
            this.flagName = flagName;
            this.flagOwner = flagOwner;
            this.rebuild();
        }

        public boolean StillValid() {
            return this.valid;
        }

        public List<String> values() {
            this.checkExpired();
            return this.value.asList();
        }

        public Value get(int index) {
            this.checkExpired();
            return this.value.get(index);
        }

        public void clear() {
            String OldOwner = this.flagOwner;
            String OldName = this.flagName;
            ListTag OldValue = FlagSmartEvent.isActive() ? (this.value.size() > 1 ? this.value.asList() : (this.value.size() == 1 ? new ElementTag(this.value.get(0).asString()) : new ElementTag("null"))) : null;
            FlagManager.this.denizen.getSaves().set(this.flagPath, null);
            FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", null);
            this.valid = false;
            this.rebuild();
            if (FlagSmartEvent.isActive()) {
                ArrayList<String> world_script_events = new ArrayList<String>();
                HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
                PlayerTag player = null;
                if (PlayerTag.matches(OldOwner)) {
                    player = PlayerTag.valueOf(OldOwner, CoreUtilities.basicContext);
                }
                NPCTag npc = null;
                if (Depends.citizens != null && NPCTag.matches(OldOwner)) {
                    npc = NPCTag.valueOf(OldOwner, CoreUtilities.basicContext);
                }
                String type = player != null ? "player" : (npc != null ? "npc" : "server");
                world_script_events.add(type + " flag cleared");
                world_script_events.add(type + " flag " + OldName + " cleared");
                context.put("owner", new ElementTag(OldOwner));
                context.put("name", new ElementTag(OldName));
                context.put("type", new ElementTag(type));
                context.put("old_value", OldValue);
                world_script_events.add("flag cleared");
                OldEventManager.doEvents(world_script_events, new BukkitScriptEntryData(player, npc), context);
            }
        }

        public Value getFirst() {
            this.checkExpired();
            return this.value.get(1);
        }

        public Value getLast() {
            this.checkExpired();
            return this.value.get(this.value.size());
        }

        public void set(Object obj) {
            this.set(obj, -1);
        }

        public void set(Object obj, int index) {
            this.checkExpired();
            if (index < 0) {
                this.value.values = null;
                this.value.size = 1;
                this.value.firstValue = (String)obj;
            } else if (this.size() == 0) {
                this.value.firstValue = (String)obj;
                this.value.size = 1;
            } else if (index > 0) {
                this.value.mustBeList();
                if (this.value.values.size() > index - 1) {
                    this.value.values.set(index - 1, (String)obj);
                } else {
                    this.value.values.add((String)obj);
                    this.value.size++;
                }
            }
            this.valid = true;
            this.save();
            this.rebuild();
        }

        public int add(Object obj) {
            this.checkExpired();
            this.value.mustBeList();
            this.value.values.add((String)obj);
            this.value.size++;
            this.valid = true;
            this.save();
            this.rebuild();
            return this.size();
        }

        public int split(Object obj, TagContext context) {
            this.checkExpired();
            ListTag split = ListTag.valueOf(obj.toString(), context);
            if (split.size() > 0) {
                this.value.mustBeList();
                for (String val : split) {
                    if (val.length() <= 0) continue;
                    this.value.values.add(val);
                    this.value.size++;
                }
                this.save();
                this.rebuild();
            }
            return this.size();
        }

        public int splitNew(Object obj, TagContext context) {
            this.checkExpired();
            ListTag split = ListTag.valueOf(obj.toString(), context);
            if (split.size() > 0) {
                this.value.mustBeList();
                this.value.values.clear();
                this.value.size = 0;
                for (String val : split) {
                    if (val.length() <= 0) continue;
                    this.value.values.add(val);
                    this.value.size++;
                }
                this.save();
                this.rebuild();
            } else {
                this.clear();
            }
            return this.size();
        }

        public void remove(Object obj) {
            this.remove(obj, -1);
        }

        public void remove(Object obj, int index) {
            this.checkExpired();
            boolean isDouble = ArgumentHelper.matchesDouble((String)obj);
            this.value.mustBeList();
            if (index <= 0 && obj != null) {
                int x = 0;
                for (String val : this.value.values) {
                    block8: {
                        if (val.equalsIgnoreCase(String.valueOf(obj))) {
                            this.value.values.remove(x);
                            this.value.size--;
                            break;
                        }
                        try {
                            if (!isDouble || !ArgumentHelper.matchesDouble(val) || !Double.valueOf(val).equals(Double.valueOf((String)obj))) break block8;
                            this.value.values.remove(x);
                            this.value.size--;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ++x;
                }
            } else if (index <= this.value.size()) {
                this.value.values.remove(index - 1);
                this.value.size--;
            }
            this.valid = true;
            this.save();
            this.rebuild();
        }

        public void setExpiration(Long expiration) {
            this.valid = true;
            this.expiration = expiration;
            this.save();
        }

        public int size() {
            this.checkExpired();
            return this.value.size();
        }

        public void save() {
            String oldOwner = this.flagOwner;
            String oldName = this.flagName;
            ListTag oldValue = null;
            if (FlagSmartEvent.isActive()) {
                ListTag oldValueList = this.value.asList();
                ObjectTag objectTag = oldValueList.size() > 1 ? oldValueList : (oldValue = oldValueList.size() == 1 ? new ElementTag(oldValueList.get(0)) : new ElementTag("null"));
            }
            if (this.value.values != null) {
                FlagManager.this.denizen.getSaves().set(this.flagPath, (Object)this.value.values);
            } else {
                FlagManager.this.denizen.getSaves().set(this.flagPath, this.value.size == 0 ? null : this.value.firstValue);
            }
            FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", this.expiration > 0L ? Long.valueOf(this.expiration) : null);
            if (FlagSmartEvent.isActive()) {
                ArrayList<String> world_script_events = new ArrayList<String>();
                HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
                PlayerTag player = null;
                if (PlayerTag.matches(oldOwner)) {
                    player = PlayerTag.valueOf(oldOwner, CoreUtilities.basicContext);
                }
                NPCTag npc = null;
                if (Depends.citizens != null && NPCTag.matches(oldOwner)) {
                    npc = NPCTag.valueOf(oldOwner, CoreUtilities.basicContext);
                }
                EntityTag entity = null;
                if (EntityTag.matches(oldOwner)) {
                    entity = EntityTag.valueOf(oldOwner, CoreUtilities.basicContext);
                }
                String type = player != null ? "player" : (npc != null ? "npc" : (entity != null ? "entity" : "server"));
                world_script_events.add(type + " flag changed");
                world_script_events.add(type + " flag " + oldName + " changed");
                context.put("owner", new ElementTag(oldOwner));
                context.put("name", new ElementTag(oldName));
                context.put("type", new ElementTag(type));
                context.put("old_value", oldValue);
                world_script_events.add("flag changed");
                OldEventManager.doEvents(world_script_events, new BukkitScriptEntryData(player, npc), context);
            }
        }

        public String toString() {
            return this.flagOwner + ":" + this.flagName;
        }

        public boolean checkExpired() {
            this.rebuild();
            if (FlagManager.this.denizen.getSaves().contains(this.flagPath + "-expiration") && this.expiration > 1L && this.expiration < DenizenCore.currentTimeMillis) {
                String oldOwner = this.flagOwner;
                String oldName = this.flagName;
                ListTag oldValue = FlagSmartEvent.isActive() ? (this.value.size() > 1 ? this.value.asList() : (this.value.size() == 1 ? new ElementTag(this.value.get(0).asString()) : new ElementTag("null"))) : null;
                FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", null);
                FlagManager.this.denizen.getSaves().set(this.flagPath, null);
                this.valid = false;
                this.rebuild();
                if (FlagSmartEvent.isActive()) {
                    ArrayList<String> world_script_events = new ArrayList<String>();
                    HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
                    PlayerTag player = null;
                    if (PlayerTag.matches(oldOwner)) {
                        player = PlayerTag.valueOf(oldOwner, CoreUtilities.basicContext);
                    }
                    NPCTag npc = null;
                    if (Depends.citizens != null && NPCTag.matches(oldOwner)) {
                        npc = NPCTag.valueOf(oldOwner, CoreUtilities.basicContext);
                    }
                    EntityTag entity = null;
                    if (EntityTag.matches(oldOwner)) {
                        entity = EntityTag.valueOf(oldOwner, CoreUtilities.basicContext);
                    }
                    String type = player != null ? "player" : (npc != null ? "npc" : (entity != null ? "entity" : "server"));
                    world_script_events.add(type + " flag expires");
                    world_script_events.add(type + " flag " + oldName + " expires");
                    context.put("owner", new ElementTag(oldOwner));
                    context.put("name", new ElementTag(oldName));
                    context.put("type", new ElementTag(type));
                    context.put("old_value", oldValue);
                    world_script_events.add("flag expires");
                    OldEventManager.doEvents(world_script_events, new BukkitScriptEntryData(player, npc), context);
                }
                return true;
            }
            return false;
        }

        public DurationTag expiration() {
            return new DurationTag((double)(this.expiration - DenizenCore.currentTimeMillis) / 1000.0);
        }

        @Deprecated
        public String expirationTime() {
            this.rebuild();
            long seconds = (this.expiration - DenizenCore.currentTimeMillis) / 1000L;
            long days = seconds / 86400L;
            long hours = (seconds - days * 86400L) / 3600L;
            long minutes = (seconds - days * 86400L - hours * 3600L) / 60L;
            seconds = seconds - days * 86400L - hours * 3600L - minutes * 60L;
            String timeString = "";
            if (days > 0L) {
                timeString = days + "d ";
            }
            if (hours > 0L) {
                timeString = timeString + hours + "h ";
            }
            if (minutes > 0L && days == 0L) {
                timeString = timeString + minutes + "m ";
            }
            if (seconds > 0L && minutes < 10L && hours == 0L && days == 0L) {
                timeString = timeString + seconds + "s";
            }
            return timeString.trim();
        }

        public Flag rebuild() {
            Object obj;
            if (FlagManager.this.denizen.getSaves().contains(this.flagPath + "-expiration")) {
                this.expiration = FlagManager.this.denizen.getSaves().getLong(this.flagPath + "-expiration");
            }
            if ((obj = FlagManager.this.denizen.getSaves().get(this.flagPath)) instanceof Map || obj instanceof MemorySection) {
                this.valid = false;
                this.value = new Value();
            } else if (obj instanceof List) {
                ArrayList<String> val = new ArrayList<String>(((List)obj).size());
                for (Object subObj : (List)obj) {
                    val.add(String.valueOf(subObj));
                }
                this.value = new Value(val);
            } else {
                this.value = obj == null || obj.toString().length() == 0 ? new Value() : new Value(obj.toString());
            }
            return this;
        }

        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        public void doAction(Action action, ElementTag value, Integer index, ScriptEntry entry) {
            String val;
            String string = val = value != null ? value.asString() : null;
            if (index == null) {
                index = -1;
            }
            if (action == null) {
                return;
            }
            switch (action) {
                case INCREASE: 
                case DECREASE: 
                case MULTIPLY: 
                case DIVIDE: {
                    double currentValue = this.get(index).asDouble();
                    this.set(CoreUtilities.doubleToString(this.math(currentValue, value.asDouble(), action)), index);
                    break;
                }
                case SET_BOOLEAN: {
                    this.set("true", index);
                    break;
                }
                case SET_VALUE: {
                    this.set(val, index);
                    break;
                }
                case INSERT: {
                    this.add(val);
                    break;
                }
                case REMOVE: {
                    this.remove(val, index);
                    break;
                }
                case SPLIT: {
                    this.split(val, entry.context);
                    break;
                }
                case SPLIT_NEW: {
                    this.splitNew(val, entry.context);
                    break;
                }
                case DELETE: {
                    this.clear();
                }
            }
        }

        private double math(double currentValue, double value, Action flagAction) {
            switch (flagAction) {
                case INCREASE: {
                    return currentValue + value;
                }
                case DECREASE: {
                    return currentValue - value;
                }
                case MULTIPLY: {
                    return currentValue * value;
                }
                case DIVIDE: {
                    return currentValue / value;
                }
            }
            return 0.0;
        }
    }

    public static enum Action {
        SET_VALUE,
        SET_BOOLEAN,
        INCREASE,
        DECREASE,
        MULTIPLY,
        DIVIDE,
        INSERT,
        REMOVE,
        SPLIT,
        SPLIT_NEW,
        DELETE;

    }
}

