/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.core.CooldownCommand;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;

public class ResetCommand
extends AbstractCommand {
    public ResetCommand() {
        this.setName("reset");
        this.setSyntax("reset (<player>|...) [cooldown/saves/global_cooldown] (<script>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matches("cooldown") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.PLAYER_COOLDOWN);
                continue;
            }
            if (arg.matches("global_cooldown") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.GLOBAL_COOLDOWN);
                continue;
            }
            if (arg.matches("saves") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.SAVES);
                continue;
            }
            if (arg.matchesArgumentType(ScriptTag.class)) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.getObject("type").equals((Object)Type.GLOBAL_COOLDOWN)) {
            scriptEntry.defaultObject("players", Utilities.getEntryPlayer(scriptEntry));
        }
        if (!scriptEntry.hasObject("script") && !scriptEntry.getObject("type").equals((Object)Type.SAVES)) {
            throw new InvalidArgumentsException("Must specify a script!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Object player = scriptEntry.getObjectTag("players");
        ListTag players = player instanceof PlayerTag ? new ListTag(new ObjectTag[]{player}) : (ListTag)scriptEntry.getObjectTag("players");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (players != null ? players.debug() : "") + ArgumentHelper.debugObj("type", (Object)type) + (script != null ? script.debug() : ""));
        }
        if (type == Type.GLOBAL_COOLDOWN) {
            CooldownCommand.setCooldown(null, DurationTag.ZERO, script.getName(), true);
            return;
        }
        for (String object : players) {
            PlayerTag resettable = PlayerTag.valueOf(object, scriptEntry.context);
            if (!resettable.isValid()) continue;
            switch (type) {
                case PLAYER_COOLDOWN: {
                    CooldownCommand.setCooldown(resettable, DurationTag.ZERO, script.getName(), false);
                    return;
                }
                case SAVES: {
                    DenizenAPI.getCurrentInstance().getSaves().set("Players." + resettable.getSaveName(), null);
                }
            }
        }
    }

    private static enum Type {
        PLAYER_COOLDOWN,
        GLOBAL_COOLDOWN,
        SAVES;

    }
}

