/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class FakeItemCommand
extends AbstractCommand {
    public FakeItemCommand() {
        this.setName("fakeitem");
        this.setSyntax("fakeitem [<item>|...] [slot:<slot>] (duration:<duration>) (players:<player>|...) (player_only)");
        this.setRequiredArguments(2, 5);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot")) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("duration") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("item") && arg.matchesArgumentList(ItemTag.class)) {
                scriptEntry.addObject("item", arg.asType(ListTag.class).filter(ItemTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesArgumentList(PlayerTag.class) && arg.matchesPrefix("players")) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("player_only") && arg.matches("player_only")) {
                scriptEntry.addObject("player_only", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify a valid item to fake!");
        }
        if (!scriptEntry.hasObject("slot")) {
            throw new InvalidArgumentsException("Must specify a valid slot!");
        }
        scriptEntry.defaultObject("duration", DurationTag.ZERO).defaultObject("player_only", new ElementTag(false)).defaultObject("players", Arrays.asList(Utilities.getEntryPlayer(scriptEntry)));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        int slot;
        List items = (List)scriptEntry.getObject("item");
        ElementTag elSlot = scriptEntry.getElement("slot");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        final List players = (List)scriptEntry.getObject("players");
        ElementTag player_only = scriptEntry.getElement("player_only");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugList("items", items) + elSlot.debug() + duration.debug() + ArgumentHelper.debugList("players", players) + player_only.debug());
        }
        if ((slot = SlotHelper.nameToIndex(elSlot.asString())) == -1) {
            Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + elSlot.asString() + "' is not a valid slot!");
            return;
        }
        final boolean playerOnly = player_only.asBoolean();
        final PacketHelper packetHelper = NMSHandler.getPacketHelper();
        for (ItemTag item : items) {
            if (item == null) {
                ++slot;
                continue;
            }
            for (PlayerTag player : players) {
                Player ent = player.getPlayerEntity();
                packetHelper.setSlot(ent, FakeItemCommand.translateSlot(ent, slot, playerOnly), item.getItemStack(), playerOnly);
            }
            final int slotSnapshot = slot++;
            if (!(duration.getSeconds() > 0.0)) continue;
            DenizenCore.schedule(new OneTimeSchedulable(new Runnable(){

                @Override
                public void run() {
                    for (PlayerTag player : players) {
                        Player ent = player.getPlayerEntity();
                        int translated = FakeItemCommand.translateSlot(ent, slotSnapshot, playerOnly);
                        ItemStack original = ent.getOpenInventory().getItem(translated);
                        packetHelper.setSlot(ent, translated, original, playerOnly);
                    }
                }
            }, (float)duration.getSeconds()));
        }
    }

    static int translateSlot(Player player, int slot, boolean player_only) {
        int result;
        int total = player_only || player.getOpenInventory().getTopInventory() instanceof CraftingInventory ? 46 : 36 + player.getOpenInventory().getTopInventory().getSize();
        if (total == 46) {
            if (slot == 45) {
                return slot;
            }
            if (slot > 35) {
                slot = 8 - (slot - 36);
                return slot;
            }
            result = (int)((double)(slot + (--total - 9)) - 9.0 * (2.0 * Math.floor((double)slot / 9.0)));
        } else {
            int row = (int)Math.floor((double)slot / 9.0);
            int column = slot - row * 9;
            int rowCount = (int)Math.ceil((double)total / 9.0);
            int realRow = rowCount - row - 1;
            result = realRow * 9 + column;
        }
        if (result < 0) {
            return 0;
        }
        if (result > total) {
            return total;
        }
        return result;
    }
}

