/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class MarkCommand
extends AbstractCommand {
    public MarkCommand() {
        this.setName("mark");
        this.setSyntax("mark [<name>]");
        this.setRequiredArguments(1, 1);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("m_name")) {
                scriptEntry.addObject("m_name", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("m_name")) {
            throw new InvalidArgumentsException("Must have a mark name!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag mName = scriptEntry.getElement("m_name");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), mName.debug());
        }
    }
}

