/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.nms.interfaces.FakeArrow;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizencore.objects.Mechanism;
import java.util.ArrayList;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;

public class SittingTrait
extends Trait
implements Listener {
    @Persist(value="sitting")
    private boolean sitting = false;
    @Persist(value="chair location")
    private Location chairLocation = null;

    public void run() {
        if (!this.npc.isSpawned() || this.chairLocation == null) {
            return;
        }
        if (!Utilities.checkLocation((LivingEntity)this.npc.getEntity(), this.chairLocation, 1.0)) {
            this.stand();
        }
    }

    public void onSpawn() {
        if (this.sitting) {
            if (this.chairLocation == null) {
                this.sit();
            } else {
                this.sit(this.chairLocation);
            }
        }
    }

    public void onDespawn() {
        if (this.npc == null || this.npc.getEntity() == null) {
            return;
        }
        if (this.npc.getEntity().getVehicle() != null) {
            this.npc.getEntity().getVehicle().setPassenger(null);
        }
    }

    public void sit() {
        if (!this.npc.isSpawned()) {
            return;
        }
        DenizenAPI.getDenizenNPC(this.npc).action("sit", null);
        this.sit(this.npc.getEntity().getLocation());
    }

    private void sitInternal() {
        if (this.npc.getEntity() instanceof Player) {
            PlayerAnimation.SIT.play((Player)this.npc.getEntity());
        } else {
            DenizenEntityType.getByName("FAKE_ARROW").spawnNewEntity(this.npc.getEntity().getLocation(), new ArrayList<Mechanism>(), null).setPassenger(this.npc.getEntity());
        }
        this.sitting = true;
    }

    private void standInternal() {
        if (this.npc.getEntity() instanceof Player) {
            PlayerAnimation.STOP_SITTING.play((Player)this.npc.getEntity());
        } else {
            Entity vehicle = this.npc.getEntity().getVehicle();
            this.npc.despawn();
            this.npc.spawn(this.npc.getStoredLocation().clone().add(0.0, 0.5, 0.0));
            if (vehicle != null && vehicle.isValid()) {
                vehicle.setPassenger(null);
                vehicle.remove();
            }
        }
        this.sitting = false;
    }

    public void sitInternal(Location location) {
        DenizenAPI.getDenizenNPC(this.npc).action("sit", null);
        this.npc.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        this.sitInternal();
    }

    public void sit(Location location) {
        this.sitInternal(location.clone().add(0.0, 0.5, 0.0));
        this.chairLocation = location.clone();
    }

    public void stand() {
        DenizenAPI.getDenizenNPC(this.npc).action("stand", null);
        this.standInternal();
        this.standInternal();
        this.chairLocation = null;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public Location getChair() {
        return this.chairLocation;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.chairLocation == null) {
            return;
        }
        if (event.getBlock().getLocation().equals((Object)this.chairLocation)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void arrowDismount(final VehicleExitEvent event) {
        if (event.getVehicle() instanceof FakeArrow) {
            Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    if (event.getVehicle().isValid()) {
                        event.getVehicle().remove();
                    }
                }
            }, 1L);
        }
    }

    public SittingTrait() {
        super("sitting");
    }
}

