/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ProjectileCollideScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ProjectileCollideScriptEvent instance;
    public ProjectileCollideEvent event;
    public EntityTag projectile;
    public EntityTag collidedWith;

    public ProjectileCollideScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("collides") || !path.eventArgLowerAt(2).equals("with")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(0)) && this.couldMatchEntity(path.eventArgLowerAt(3));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getEntity().getLocation())) {
            return false;
        }
        if (!this.tryEntity(this.projectile, path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.tryEntity(this.collidedWith, path.eventArgLowerAt(3))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "ProjectileCollides";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.collidedWith);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.collidedWith;
        }
        if (name.equals("projectile")) {
            return this.projectile;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void projectileCollideEvent(ProjectileCollideEvent event) {
        this.event = event;
        this.collidedWith = new EntityTag(event.getCollidedWith());
        this.projectile = new EntityTag((Entity)event.getEntity());
        this.fire((Event)event);
    }
}

