/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.scripts.commands.entity.WalkCommand;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import java.util.List;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationEvent;
import net.citizensnpcs.api.ai.flocking.AlignmentBehavior;
import net.citizensnpcs.api.ai.flocking.CohesionBehavior;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.ai.flocking.Flocker;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.ai.flocking.RadiusNPCFlock;
import net.citizensnpcs.api.ai.flocking.SeparationBehavior;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WalkCommandCitizensEvents
implements Listener {
    public static double HIGH_INFLUENCE = 0.05;
    public static double LOW_INFLUENCE = 0.005;

    public static Flocker generateNewFlocker(NPC npc, double radius) {
        RadiusNPCFlock flock = new RadiusNPCFlock(radius);
        return new Flocker(npc, (NPCFlock)flock, new FlockBehavior[]{new SeparationBehavior(LOW_INFLUENCE), new CohesionBehavior(LOW_INFLUENCE), new AlignmentBehavior(HIGH_INFLUENCE)});
    }

    @EventHandler
    public void finish(NavigationCompleteEvent e) {
        if (WalkCommand.held.isEmpty()) {
            return;
        }
        this.checkHeld((NavigationEvent)e);
    }

    @EventHandler
    public void cancel(NavigationCancelEvent e) {
        if (WalkCommand.held.isEmpty()) {
            return;
        }
        this.checkHeld((NavigationEvent)e);
    }

    public void checkHeld(NavigationEvent e) {
        if (e.getNPC() == null) {
            return;
        }
        for (int i = 0; i < WalkCommand.held.size(); ++i) {
            ScriptEntry entry = WalkCommand.held.get(i);
            List tally = (List)entry.getObject("tally");
            if (tally == null) {
                WalkCommand.held.remove(i--);
                continue;
            }
            for (int x = 0; x < tally.size(); ++x) {
                if (((NPCTag)tally.get(x)).isSpawned()) continue;
                tally.remove(x--);
            }
            tally.remove(new NPCTag(e.getNPC()));
            if (!tally.isEmpty()) continue;
            Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), () -> entry.setFinished(true), 1L);
            WalkCommand.held.remove(i--);
        }
    }
}

