/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.events.world.TimeChangeScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;

public class BukkitWorldScriptHelper
implements Listener {
    private final Map<String, Integer> current_time = new HashMap<String, Integer>();

    public BukkitWorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void serverStartEvent() {
        long ticks = Settings.worldScriptTimeEventFrequency().getTicks();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                BukkitWorldScriptHelper.this.timeEvent();
            }
        }, ticks, ticks);
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            WorldTag currentWorld;
            int hour = (int)(world.getTime() / 1000L);
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey((currentWorld = new WorldTag(world)).identifySimple()) && this.current_time.get(currentWorld.identifySimple()) == hour) continue;
            this.current_time.put(currentWorld.identifySimple(), hour);
            TimeChangeScriptEvent.instance.hour = hour;
            TimeChangeScriptEvent.instance.world = currentWorld;
            TimeChangeScriptEvent.instance.fire();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoins(PlayerJoinEvent event) {
        Scoreboard score;
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (ScoreboardHelper.viewerMap.containsKey(event.getPlayer().getName()) && (score = ScoreboardHelper.getScoreboard(ScoreboardHelper.viewerMap.get(event.getPlayer().getName()))) != null) {
            event.getPlayer().setScoreboard(score);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final String message = ChatColor.DARK_GREEN + "CHAT: " + event.getPlayer().getName() + ": " + event.getMessage();
        Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                if (Debug.record) {
                    Debug.log(message);
                }
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerLogin(PlayerLoginEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        PlayerTag.notePlayer((OfflinePlayer)event.getPlayer());
    }
}

