/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public class HealthTrait
extends Trait
implements Listener {
    @Persist(value="animatedeath")
    private boolean animatedeath = Settings.healthTraitAnimatedDeathEnabled();
    @Persist(value="respawnondeath")
    private boolean respawn = Settings.healthTraitRespawnEnabled();
    @Persist(value="respawndelayinseconds")
    private String respawnDelay = Settings.healthTraitRespawnDelay();
    @Persist(value="respawnlocation")
    private String respawnLocation = "<npc.flag[respawn_location] || <npc.location>>";
    @Persist(value="blockdrops")
    private boolean blockDrops = Settings.healthTraitBlockDrops();
    private boolean dying = false;
    private Location loc;
    private UUID entityId = null;
    public Integer void_watcher_task = null;

    public DurationTag getRespawnDelay() {
        return DurationTag.valueOf(this.respawnDelay, CoreUtilities.basicContext);
    }

    public void setRespawnLocation(String string) {
        this.respawnLocation = string;
    }

    public void setRespawnDelay(int seconds) {
        this.respawnDelay = String.valueOf(seconds);
    }

    public void setRespawnDelay(String string) {
        this.respawnDelay = string;
    }

    public String getRespawnLocationAsString() {
        return this.respawnLocation;
    }

    public Location getRespawnLocation() {
        BukkitTagContext context = new BukkitTagContext(null, new NPCTag(this.npc), null, false, null);
        return LocationTag.valueOf(TagManager.tag(this.respawnLocation, context), context);
    }

    public void setRespawnable(boolean respawnable) {
        this.respawn = respawnable;
    }

    public boolean isRespawnable() {
        return this.respawn;
    }

    public void animateOnDeath(boolean animate) {
        this.animatedeath = animate;
    }

    public boolean animatesOnDeath() {
        return this.animatedeath;
    }

    public void onSpawn() {
        this.dying = false;
        this.setHealth();
        this.void_watcher_task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Denizen.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (!HealthTrait.this.npc.isSpawned()) {
                    Bukkit.getScheduler().cancelTask(HealthTrait.this.void_watcher_task.intValue());
                    return;
                }
                if (HealthTrait.this.npc.getEntity().getLocation().getY() < -1000.0) {
                    HealthTrait.this.npc.despawn(DespawnReason.DEATH);
                    if (HealthTrait.this.respawn) {
                        Location res = HealthTrait.this.getRespawnLocation();
                        if (res.getY() < 1.0) {
                            res.setY((double)res.getWorld().getHighestBlockYAt(res.getBlockX(), res.getBlockZ()));
                        }
                        if (HealthTrait.this.npc.isSpawned()) {
                            HealthTrait.this.npc.getEntity().teleport(res);
                        } else {
                            HealthTrait.this.npc.spawn(res);
                        }
                    }
                }
            }
        }, 200L, 200L);
    }

    public HealthTrait() {
        super("health");
    }

    public double getHealth() {
        if (!this.npc.isSpawned()) {
            return 0.0;
        }
        return ((LivingEntity)this.npc.getEntity()).getHealth();
    }

    public void setMaxhealth(int newMax) {
        ((LivingEntity)this.npc.getEntity()).setMaxHealth((double)newMax);
    }

    public double getMaxhealth() {
        return ((LivingEntity)this.npc.getEntity()).getMaxHealth();
    }

    public void heal(int health) {
        this.setHealth(this.getHealth() + (double)health);
    }

    public void setHealth() {
        this.setHealth(((LivingEntity)this.npc.getEntity()).getMaxHealth());
    }

    public void setHealth(double health) {
        if (this.npc.getEntity() != null) {
            ((LivingEntity)this.npc.getEntity()).setHealth(health);
        }
    }

    public void die() {
        ((LivingEntity)this.npc.getEntity()).damage(((LivingEntity)this.npc.getEntity()).getHealth());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(EntityDeathEvent event) {
        if (this.entityId == null || !event.getEntity().getUniqueId().equals(this.entityId)) {
            return;
        }
        if (this.blockDrops) {
            event.getDrops().clear();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity() != this.npc.getEntity() || this.dying) {
            return;
        }
        if (this.getHealth() - event.getFinalDamage() > 0.0) {
            return;
        }
        this.dying = true;
        this.entityId = this.npc.getEntity().getUniqueId();
        if (this.npc.getEntity() == null) {
            return;
        }
        BukkitTagContext context = new BukkitTagContext(null, new NPCTag(this.npc), null, true, null);
        this.loc = this.getRespawnLocation();
        if (this.loc == null) {
            this.loc = this.npc.getEntity().getLocation();
        }
        if (this.animatedeath) {
            this.npc.getNavigator().cancelNavigation();
        }
        if (this.respawn && this.getRespawnDelay().getTicks() > 0L) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (CitizensAPI.getNPCRegistry().getById(HealthTrait.this.npc.getId()) == null || HealthTrait.this.npc.isSpawned()) {
                        return;
                    }
                    HealthTrait.this.npc.spawn(HealthTrait.this.loc);
                }
            }, this.getRespawnDelay().getTicks());
        }
    }
}

