/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashSet;

public class DebugCommand
extends AbstractCommand
implements Holdable {
    public static HashSet<String> DBINFO = Argument.precalcEnum(DebugType.values());

    public DebugCommand() {
        this.setName("debug");
        this.setSyntax("debug [<type>] [<message>] (name:<name>)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(DBINFO)) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("name") && arg.matchesPrefix("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("debug")) {
                scriptEntry.addObject("debug", new ElementTag(arg.getRawValue()));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("type") || !scriptEntry.hasObject("debug")) {
            throw new InvalidArgumentsException("Must specify a debug type and message!");
        }
        scriptEntry.defaultObject("name", new ElementTag("name"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag debug = scriptEntry.getElement("debug");
        ElementTag type = scriptEntry.getElement("type");
        ElementTag name = scriptEntry.getElement("name");
        DebugType dbType = DebugType.valueOf(type.asString().toUpperCase());
        if (dbType != DebugType.RECORD) {
            scriptEntry.setFinished(true);
        }
        switch (dbType) {
            case DEBUG: {
                Debug.echoDebug((Debuggable)scriptEntry, debug.asString());
                break;
            }
            case HEADER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, debug.asString());
                break;
            }
            case FOOTER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Footer, debug.asString());
                break;
            }
            case SPACER: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Spacer, debug.asString());
                break;
            }
            case LOG: {
                Debug.log(debug.asString());
                break;
            }
            case APPROVAL: {
                Debug.echoApproval(debug.asString());
                break;
            }
            case ERROR: {
                Debug.echoError(scriptEntry.getResidingQueue(), debug.asString());
                break;
            }
            case REPORT: {
                if (!scriptEntry.dbCallShouldDebug()) break;
                Debug.report(scriptEntry, name.asString(), debug.asString());
                break;
            }
            case EXCEPTION: {
                Debug.echoError(scriptEntry.getResidingQueue(), new RuntimeException(debug.asString()));
                break;
            }
            case RECORD: {
                String form = CoreUtilities.toLowerCase(debug.asString());
                if (form.equals("start")) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Starting debug recording...");
                    DenizenCore.getImplementation().startRecording();
                    scriptEntry.setFinished(true);
                    break;
                }
                if (form.equals("cancel")) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Stopping debug recording...");
                    DenizenCore.getImplementation().stopRecording();
                    scriptEntry.setFinished(true);
                    break;
                }
                if (form.equals("submit")) {
                    DenizenCore.getImplementation().submitRecording(s -> {
                        if (s == null) {
                            Debug.echoDebug((Debuggable)scriptEntry, "Submit failed.");
                        } else if (s.equals("disabled")) {
                            Debug.echoDebug((Debuggable)scriptEntry, "Submit failed: not recording");
                        } else {
                            Debug.echoDebug((Debuggable)scriptEntry, "Submitted to " + s);
                            scriptEntry.addObject("submitted", new ElementTag((String)s));
                        }
                        scriptEntry.setFinished(true);
                    });
                    break;
                }
                Debug.echoError("Debug 'record' command failed: unknown record form '" + form + "'");
                scriptEntry.setFinished(true);
            }
        }
    }

    public static enum DebugType {
        DEBUG,
        HEADER,
        FOOTER,
        SPACER,
        LOG,
        APPROVAL,
        ERROR,
        REPORT,
        EXCEPTION,
        RECORD;

    }
}

