/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.TextWidthHelper;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.ChatColor;

public class BukkitElementProperties
implements Property {
    public static final String[] handledMechs = new String[0];
    ElementTag element;
    public static AsciiMatcher HEX_MATCHER = new AsciiMatcher("abcdefABCDEF0123456789");

    public static boolean describes(ObjectTag element) {
        return element instanceof ElementTag;
    }

    public static BukkitElementProperties getFrom(ObjectTag element) {
        if (!BukkitElementProperties.describes(element)) {
            return null;
        }
        return new BukkitElementProperties((ElementTag)element);
    }

    private BukkitElementProperties(ElementTag element) {
        this.element = element;
    }

    public static String replaceEssentialsHexColors(char prefix, String input) {
        int hex = input.indexOf(prefix + "#");
        while (hex != -1 && hex < input.length() + 8) {
            StringBuilder converted = new StringBuilder(10);
            converted.append('\u00a7').append("x");
            for (int i = 0; i < 6; ++i) {
                char c = input.charAt(hex + 2 + i);
                if (!HEX_MATCHER.isMatch(c)) {
                    return input;
                }
                converted.append('\u00a7').append(c);
            }
            input = input.substring(0, hex) + converted.toString() + input.substring(hex + 8);
            hex = input.indexOf(prefix + "#", hex + 2);
        }
        return input;
    }

    public static void registerTags() {
        PropertyParser.registerTag("as_chunk", (attribute, object) -> ElementTag.handleNull(object.asString(), ChunkTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "ChunkTag", attribute.hasAlternative()), "aschunk");
        PropertyParser.registerTag("as_color", (attribute, object) -> ElementTag.handleNull(object.asString(), ColorTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "ColorTag", attribute.hasAlternative()), "ascolor");
        PropertyParser.registerTag("as_cuboid", (attribute, object) -> ElementTag.handleNull(object.asString(), CuboidTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "CuboidTag", attribute.hasAlternative()), "ascuboid");
        PropertyParser.registerTag("as_entity", (attribute, object) -> ElementTag.handleNull(object.asString(), EntityTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "EntityTag", attribute.hasAlternative()), "asentity");
        PropertyParser.registerTag("as_inventory", (attribute, object) -> ElementTag.handleNull(object.asString(), InventoryTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "InventoryTag", attribute.hasAlternative()), "asinventory");
        PropertyParser.registerTag("as_item", (attribute, object) -> ElementTag.handleNull(object.asString(), ItemTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "ItemTag", attribute.hasAlternative()), "asitem");
        PropertyParser.registerTag("as_location", (attribute, object) -> ElementTag.handleNull(object.asString(), LocationTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "LocationTag", attribute.hasAlternative()), "aslocation");
        PropertyParser.registerTag("as_material", (attribute, object) -> ElementTag.handleNull(object.asString(), MaterialTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "MaterialTag", attribute.hasAlternative()), "asmaterial");
        PropertyParser.registerTag("as_npc", (attribute, object) -> ElementTag.handleNull(object.asString(), NPCTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "NPCTag", attribute.hasAlternative()), "asnpc");
        PropertyParser.registerTag("as_player", (attribute, object) -> ElementTag.handleNull(object.asString(), PlayerTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "PlayerTag", attribute.hasAlternative()), "asplayer");
        PropertyParser.registerTag("as_world", (attribute, object) -> ElementTag.handleNull(object.asString(), WorldTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "WorldTag", attribute.hasAlternative()), "asworld");
        PropertyParser.registerTag("as_plugin", (attribute, object) -> ElementTag.handleNull(object.asString(), PluginTag.valueOf(object.asString(), new BukkitTagContext(attribute.getScriptEntry())), "PluginTag", attribute.hasAlternative()), "asplugin");
        PropertyParser.registerTag("format", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(attribute.getContext(1));
            if (format == null) {
                attribute.echoError("Could not find format script matching '" + attribute.getContext(1) + "'");
                return null;
            }
            return new ElementTag(format.getFormattedText(object.asString(), attribute.getScriptEntry() != null ? ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getNPC() : null, attribute.getScriptEntry() != null ? ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getPlayer() : null));
        }, new String[0]);
        PropertyParser.registerTag("split_lines_by_width", (attribute, object) -> {
            int width = attribute.getIntContext(1);
            return new ElementTag(TextWidthHelper.splitLines(object.asString(), width));
        }, new String[0]);
        PropertyParser.registerTag("text_width", (attribute, object) -> new ElementTag(TextWidthHelper.getWidth(object.asString())), new String[0]);
        PropertyParser.registerTag("lines_to_colored_list", (attribute, object) -> {
            ListTag output = new ListTag();
            String colors = "";
            for (String line : CoreUtilities.split(object.asString(), '\n')) {
                output.add(colors + line);
                colors = ChatColor.getLastColors((String)(colors + line));
            }
            return output;
        }, new String[0]);
        PropertyParser.registerTag("last_color", (attribute, object) -> new ElementTag(ChatColor.getLastColors((String)object.asString())), new String[0]);
        PropertyParser.registerTag("strip_color", (attribute, object) -> new ElementTag(FormattedTextHelper.parse(object.asString(), net.md_5.bungee.api.ChatColor.WHITE)[0].toPlainText()), new String[0]);
        PropertyParser.registerTag("parse_color", (attribute, object) -> {
            char prefix = '&';
            if (attribute.hasContext(1)) {
                prefix = attribute.getContext(1).charAt(0);
            }
            String parsed = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)prefix, (String)object.asString());
            parsed = BukkitElementProperties.replaceEssentialsHexColors(prefix, parsed);
            return new ElementTag(parsed);
        }, new String[0]);
        PropertyParser.registerTag("to_itemscript_hash", (attribute, object) -> new ElementTag(ItemScriptHelper.createItemScriptID(object.asString())), new String[0]);
        PropertyParser.registerTag("to_secret_colors", (attribute, object) -> {
            String text = object.asString();
            byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
            String hex = DatatypeConverter.printHexBinary((byte[])bytes);
            StringBuilder colors = new StringBuilder(text.length() * 2);
            for (int i = 0; i < hex.length(); ++i) {
                colors.append('\u00a7').append(hex.charAt(i));
            }
            return new ElementTag(colors.toString());
        }, new String[0]);
        PropertyParser.registerTag("from_secret_colors", (attribute, object) -> {
            String text = object.asString().replace(String.valueOf('\u00a7'), "");
            byte[] bytes = DatatypeConverter.parseHexBinary((String)text);
            return new ElementTag(new String(bytes, StandardCharsets.UTF_8));
        }, new String[0]);
        PropertyParser.registerTag("to_raw_json", (attribute, object) -> new ElementTag(ComponentSerializer.toString((BaseComponent[])FormattedTextHelper.parse(object.asString(), net.md_5.bungee.api.ChatColor.WHITE))), new String[0]);
        PropertyParser.registerTag("from_raw_json", (attribute, object) -> new ElementTag(FormattedTextHelper.stringify(ComponentSerializer.parse((String)object.asString()), net.md_5.bungee.api.ChatColor.WHITE)), new String[0]);
        PropertyParser.registerTag("on_hover", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String hoverText = attribute.getContext(1);
            String type = "SHOW_TEXT";
            if (attribute.startsWith("type", 2)) {
                type = attribute.getContext(2);
                attribute.fulfill(1);
            }
            return new ElementTag("\u00a7[hover=" + type + ";" + FormattedTextHelper.escape(hoverText) + "]" + object.asString() + '\u00a7' + "[/hover]");
        }, new String[0]);
        PropertyParser.registerTag("on_click", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String clickText = attribute.getContext(1);
            String type = "RUN_COMMAND";
            if (attribute.startsWith("type", 2)) {
                type = attribute.getContext(2);
                attribute.fulfill(1);
            }
            return new ElementTag("\u00a7[click=" + type + ";" + FormattedTextHelper.escape(clickText) + "]" + object.asString() + '\u00a7' + "[/click]");
        }, new String[0]);
        PropertyParser.registerTag("with_insertion", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String insertionText = attribute.getContext(1);
            return new ElementTag("\u00a7[insertion=" + FormattedTextHelper.escape(insertionText) + "]" + object.asString() + '\u00a7' + "[/insertion]");
        }, new String[0]);
        PropertyParser.registerTag("no_reset", (attribute, object) -> {
            if (object.asString().length() == 2 && object.asString().charAt(0) == '\u00a7') {
                return new ElementTag("\u00a7[color=" + object.asString().charAt(1) + "]");
            }
            return null;
        }, new String[0]);
        PropertyParser.registerTag("end_format", (attribute, object) -> {
            if (object.asString().length() == 2 && object.asString().charAt(0) == '\u00a7') {
                return new ElementTag("\u00a7[reset=" + object.asString().charAt(1) + "]");
            }
            return null;
        }, new String[0]);
        PropertyParser.registerTag("italicize", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.ITALIC + object.asString() + '\u00a7' + "[reset=o]"), new String[0]);
        PropertyParser.registerTag("bold", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.BOLD + object.asString() + '\u00a7' + "[reset=l]"), new String[0]);
        PropertyParser.registerTag("underline", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.UNDERLINE + object.asString() + '\u00a7' + "[reset=n]"), new String[0]);
        PropertyParser.registerTag("strikethrough", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.STRIKETHROUGH + object.asString() + '\u00a7' + "[reset=m]"), new String[0]);
        PropertyParser.registerTag("obfuscate", (attribute, object) -> new ElementTag(net.md_5.bungee.api.ChatColor.MAGIC + object.asString() + '\u00a7' + "[reset=k]"), new String[0]);
        PropertyParser.registerTag("color", (attribute, object) -> {
            net.md_5.bungee.api.ChatColor color;
            if (!attribute.hasContext(1)) {
                return null;
            }
            String colorName = attribute.getContext(1);
            String colorOut = null;
            if (colorName.length() == 1) {
                color = net.md_5.bungee.api.ChatColor.getByChar((char)colorName.charAt(0));
                if (color != null) {
                    colorOut = color.toString();
                }
            } else {
                if (colorName.length() == 7 && colorName.startsWith("#")) {
                    return new ElementTag("\u00a7[color=" + colorName + "]" + object.asString() + '\u00a7' + "[reset=f]");
                }
                if (colorName.startsWith("co@")) {
                    ColorTag color2 = ColorTag.valueOf(colorName, attribute.context);
                    String hex = Integer.toHexString(color2.getColor().asRGB());
                    while (hex.length() < 6) {
                        hex = "0" + hex;
                    }
                    return new ElementTag("\u00a7[color=#" + hex + "]" + object.asString() + '\u00a7' + "[reset=f]");
                }
            }
            if (colorOut == null) {
                try {
                    color = net.md_5.bungee.api.ChatColor.of((String)colorName.toUpperCase());
                    colorOut = color.toString();
                }
                catch (IllegalArgumentException ex) {
                    attribute.echoError("Color '" + colorName + "' doesn't exist (for ElementTag.color[...]).");
                    return null;
                }
            }
            return new ElementTag(colorOut + object.asString() + '\u00a7' + "[reset=" + colorOut.substring(1) + "]");
        }, new String[0]);
        PropertyParser.registerTag("font", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String fontName = attribute.getContext(1);
            return new ElementTag("\u00a7[font=" + fontName + "]" + object.asString() + '\u00a7' + "[reset=font]");
        }, new String[0]);
        PropertyParser.registerTag("rainbow", (attribute, object) -> {
            String str = object.asString();
            String pattern = "4c6e2ab319d5";
            if (attribute.hasContext(1)) {
                pattern = attribute.getContext(1);
            }
            StringBuilder output = new StringBuilder(str.length() * 3);
            for (int i = 0; i < str.length(); ++i) {
                output.append('\u00a7').append(pattern.charAt(i % pattern.length())).append(str.charAt(i));
            }
            return new ElementTag(output.toString());
        }, new String[0]);
    }

    public String asString() {
        return this.element.asString();
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "BukkitElementProperties";
    }

    @Override
    public void adjust(Mechanism mechanism) {
    }
}

