/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.impl;

import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BiomeSettingsMobs;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumCreatureType;
import net.minecraft.server.v1_16_R3.IRegistry;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    private final BiomeBase biomeBase;

    public BiomeNMSImpl(Biome biome) {
        super(biome);
        World world = (World)Bukkit.getWorlds().get(0);
        this.biomeBase = CraftBlock.biomeToBiomeBase((IRegistry)((CraftWorld)world).getHandle().r().b(IRegistry.ay), (Biome)biome);
    }

    public float getHumidity() {
        return this.biomeBase.getHumidity();
    }

    public float getTemperature() {
        return this.biomeBase.k();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.AMBIENT);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.CREATURE);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.MONSTER);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.WATER_CREATURE);
    }

    public void setHumidity(float humidity) {
        ReflectionHelper.setFieldValue(BiomeBase.class, (String)"j", (Object)this.biomeBase, (Object)Float.valueOf(humidity));
    }

    public void setTemperature(float temperature) {
        ReflectionHelper.setFieldValue(BiomeBase.class, (String)"i", (Object)this.biomeBase, (Object)Float.valueOf(temperature));
    }

    protected boolean getDoesRain() {
        return this.biomeBase.c() == BiomeBase.Precipitation.RAIN;
    }

    protected boolean getDoesSnow() {
        return this.biomeBase.c() == BiomeBase.Precipitation.SNOW;
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        BiomeSettingsMobs mobs = this.biomeBase.b();
        List typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (BiomeSettingsMobs.c meta : typeSettingList) {
            try {
                String n = EntityTypes.getName((EntityTypes)meta.c).getKey();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }
}

