/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.bukkit.DyeColor;

public class ColorTag
implements ObjectTag {
    public static HashMap<org.bukkit.Color, String> nameByColor = new HashMap();
    public static HashMap<String, org.bukkit.Color> colorsByName = new HashMap();
    public static AsciiMatcher HexMatcher;
    private org.bukkit.Color color;
    String prefix = "color";
    public static ObjectTagProcessor<ColorTag> tagProcessor;

    @Deprecated
    public static ColorTag valueOf(String string) {
        return ColorTag.valueOf(string, null);
    }

    @Fetchable(value="co")
    public static ColorTag valueOf(String string, TagContext context) {
        if (string.startsWith("co@")) {
            string = string.substring("co@".length());
        }
        if (string.equals("random")) {
            return new ColorTag(CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256));
        }
        if (string.startsWith("#") && string.length() == 7 && HexMatcher.isOnlyMatches(string.substring(1))) {
            return new ColorTag(org.bukkit.Color.fromRGB((int)Integer.parseInt(string.substring(1), 16)));
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() == 3) {
            if (!(ArgumentHelper.matchesInteger(split.get(0)) && ArgumentHelper.matchesInteger(split.get(1)) && ArgumentHelper.matchesInteger(split.get(2)))) {
                return null;
            }
            return new ColorTag(Integer.parseInt(split.get(0)), Integer.parseInt(split.get(1)), Integer.parseInt(split.get(2)));
        }
        org.bukkit.Color col = colorsByName.get(CoreUtilities.toLowerCase(string));
        if (col != null) {
            return new ColorTag(col);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("co@")) {
            return true;
        }
        return ColorTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public ColorTag(int red, int green, int blue) {
        this.color = org.bukkit.Color.fromRGB((int)red, (int)green, (int)blue);
    }

    public ColorTag(org.bukkit.Color color) {
        this.color = color;
    }

    public ColorTag(DyeColor dyeColor) {
        this.color = dyeColor.getColor();
    }

    public org.bukkit.Color getColor() {
        return this.color;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Color";
    }

    @Override
    public String identify() {
        String name = nameByColor.get(this.getColor());
        if (name != null) {
            return "co@" + name;
        }
        return "co@" + this.getColor().getRed() + "," + this.getColor().getGreen() + "," + this.getColor().getBlue();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        ColorTag.registerTag("red", (attribute, object) -> new ElementTag(object.color.getRed()), new String[0]);
        ColorTag.registerTag("green", (attribute, object) -> new ElementTag(object.color.getGreen()), new String[0]);
        ColorTag.registerTag("blue", (attribute, object) -> new ElementTag(object.color.getBlue()), new String[0]);
        ColorTag.registerTag("rgb", (attribute, object) -> {
            org.bukkit.Color color = object.color;
            return new ElementTag(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        }, new String[0]);
        ColorTag.registerTag("hue", (attribute, object) -> new ElementTag(object.ToHSB()[0]), new String[0]);
        ColorTag.registerTag("saturation", (attribute, object) -> new ElementTag(object.ToHSB()[1]), new String[0]);
        ColorTag.registerTag("brightness", (attribute, object) -> new ElementTag(object.ToHSB()[2]), new String[0]);
        ColorTag.registerTag("hsv", (attribute, object) -> {
            int[] HSV = object.ToHSB();
            return new ElementTag(HSV[0] + "," + HSV[1] + "," + HSV[2]);
        }, new String[0]);
        ColorTag.registerTag("with_red", (attribute, object) -> new ColorTag(object.color.setRed(attribute.getIntContext(1))), new String[0]);
        ColorTag.registerTag("with_green", (attribute, object) -> new ColorTag(object.color.setGreen(attribute.getIntContext(1))), new String[0]);
        ColorTag.registerTag("with_blue", (attribute, object) -> new ColorTag(object.color.setBlue(attribute.getIntContext(1))), new String[0]);
        ColorTag.registerTag("with_hue", (attribute, object) -> {
            int[] HSB = object.ToHSB();
            HSB[0] = attribute.getIntContext(1);
            return ColorTag.fromHSB(HSB);
        }, new String[0]);
        ColorTag.registerTag("with_saturation", (attribute, object) -> {
            int[] HSB = object.ToHSB();
            HSB[1] = attribute.getIntContext(1);
            return ColorTag.fromHSB(HSB);
        }, new String[0]);
        ColorTag.registerTag("with_brightness", (attribute, object) -> {
            int[] HSB = object.ToHSB();
            HSB[2] = attribute.getIntContext(1);
            return ColorTag.fromHSB(HSB);
        }, new String[0]);
        ColorTag.registerTag("name", (attribute, object) -> new ElementTag(object.identify().substring(3)), new String[0]);
        ColorTag.registerTag("mix", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag ListTag.insert[...] must have a value.");
                return null;
            }
            ColorTag mixed_with = attribute.contextAsType(1, ColorTag.class);
            if (mixed_with != null) {
                return new ColorTag(object.color.mixColors(new org.bukkit.Color[]{mixed_with.getColor()}));
            }
            Debug.echoError("'" + attribute.getContext(1) + "' is not a valid color!");
            return null;
        }, new String[0]);
        ColorTag.registerTag("to_particle_offset", (attribute, object) -> {
            org.bukkit.Color valid = object.color;
            if (valid.asRGB() == 0) {
                valid = org.bukkit.Color.fromRGB((int)1, (int)0, (int)0);
            }
            return new LocationTag(null, (double)((float)valid.getRed() / 255.0f), (double)((float)valid.getGreen() / 255.0f), (float)valid.getBlue() / 255.0f);
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<ColorTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public static ColorTag fromHSB(int[] hsv) {
        int rgb = Color.HSBtoRGB((float)hsv[0] / 255.0f, (float)hsv[1] / 255.0f, (float)hsv[2] / 255.0f) & 0xFFFFFF;
        return new ColorTag(org.bukkit.Color.fromRGB((int)rgb));
    }

    public int[] ToHSB() {
        float[] base = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        return new int[]{Math.round(base[0] * 255.0f), Math.round(base[1] * 255.0f), Math.round(base[2] * 255.0f)};
    }

    static {
        for (Field field : org.bukkit.Color.class.getDeclaredFields()) {
            if (field.getType() != org.bukkit.Color.class) continue;
            try {
                org.bukkit.Color color = (org.bukkit.Color)field.get(null);
                colorsByName.put(CoreUtilities.toLowerCase(field.getName()), color);
                nameByColor.put(color, CoreUtilities.toLowerCase(field.getName()));
            }
            catch (Exception ex) {
                Debug.echoError(ex);
            }
        }
        HexMatcher = new AsciiMatcher("0123456789abcdefABCDEF");
        tagProcessor = new ObjectTagProcessor();
    }
}

