/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.Position;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PushCommand
extends AbstractCommand
implements Holdable {
    public PushCommand() {
        this.setName("push");
        this.setSyntax("push [<entity>|...] (origin:<entity>/<location>) (destination:<location>) (speed:<#.#>) (duration:<duration>) (script:<name>) (def:<element>|...) (force_along) (precision:<#>) (no_rotate) (no_damage) (ignore_collision)");
        this.setRequiredArguments(1, 12);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("origin") && arg.matchesPrefix("origin", "o", "source", "shooter", "s")) {
                if (arg.matchesArgumentType(EntityTag.class)) {
                    scriptEntry.addObject("origin_entity", arg.asType(EntityTag.class));
                    continue;
                }
                if (arg.matchesArgumentType(LocationTag.class)) {
                    scriptEntry.addObject("origin_location", arg.asType(LocationTag.class));
                    continue;
                }
                Debug.echoError("Ignoring unrecognized argument: " + arg.getRawValue());
                continue;
            }
            if (!scriptEntry.hasObject("destination") && arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("destination", "d")) {
                scriptEntry.addObject("destination", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class) && arg.matchesPrefix("duration", "d")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesFloat() && arg.matchesPrefix("speed", "s")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && (arg.matchesArgumentType(ScriptTag.class) && arg.asType(ScriptTag.class).getContainer() instanceof TaskScriptContainer || arg.matchesPrefix("script"))) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("force_along") && arg.matches("force_along")) {
                scriptEntry.addObject("force_along", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("no_rotate") && arg.matches("no_rotate")) {
                scriptEntry.addObject("no_rotate", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("precision") && arg.matchesPrefix("precision")) {
                scriptEntry.addObject("precision", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("no_damage") && arg.matches("no_damage")) {
                scriptEntry.addObject("no_damage", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("ignore_collision") && arg.matches("ignore_collision")) {
                scriptEntry.addObject("ignore_collision", new ElementTag(true));
                continue;
            }
            if (arg.matchesPrefix("def", "define", "context")) {
                scriptEntry.addObject("definitions", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("origin_location")) {
            scriptEntry.defaultObject("origin_entity", Utilities.entryDefaultEntity(scriptEntry, false));
        }
        scriptEntry.defaultObject("speed", new ElementTag(1.5));
        scriptEntry.defaultObject("duration", new DurationTag(20));
        scriptEntry.defaultObject("force_along", new ElementTag(false));
        scriptEntry.defaultObject("precision", new ElementTag(2));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("origin_entity") && !scriptEntry.hasObject("origin_location")) {
            throw new InvalidArgumentsException("Must specify an origin location!");
        }
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        boolean ignoreCollision;
        LocationTag destination;
        boolean no_damage;
        EntityTag originEntity = (EntityTag)scriptEntry.getObjectTag("origin_entity");
        LocationTag originLocation = scriptEntry.hasObject("origin_location") ? (LocationTag)scriptEntry.getObject("origin_location") : new LocationTag(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection()).subtract(0.0, 0.4, 0.0));
        boolean no_rotate = scriptEntry.hasObject("no_rotate") && scriptEntry.getElement("no_rotate").asBoolean();
        boolean bl = no_damage = scriptEntry.hasObject("no_damage") && scriptEntry.getElement("no_damage").asBoolean();
        LocationTag locationTag = scriptEntry.hasObject("destination") ? (LocationTag)scriptEntry.getObject("destination") : (destination = originEntity != null ? new LocationTag(originEntity.getEyeLocation().add(originEntity.getEyeLocation().getDirection().multiply(30))) : null);
        if (destination == null) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report(scriptEntry, this.getName(), "No destination specified!");
            }
            scriptEntry.setFinished(true);
            return;
        }
        List entities = (List)scriptEntry.getObject("entities");
        final ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        final ListTag definitions = (ListTag)scriptEntry.getObjectTag("definitions");
        final double speed = scriptEntry.getElement("speed").asDouble();
        final int maxTicks = ((DurationTag)scriptEntry.getObject("duration")).getTicksAsInt();
        ElementTag force_along = scriptEntry.getElement("force_along");
        ElementTag precision = scriptEntry.getElement("precision");
        ElementTag ignore_collision = scriptEntry.getElement("ignore_collision");
        boolean bl2 = ignoreCollision = ignore_collision != null && ignore_collision.asBoolean();
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("origin", originEntity != null ? originEntity : originLocation) + ArgumentHelper.debugObj("entities", entities.toString()) + ArgumentHelper.debugObj("destination", destination) + ArgumentHelper.debugObj("speed", speed) + ArgumentHelper.debugObj("max ticks", maxTicks) + (script != null ? script.debug() : "") + force_along.debug() + precision.debug() + (no_rotate ? ArgumentHelper.debugObj("no_rotate", "true") : "") + (no_damage ? ArgumentHelper.debugObj("no_damage", "true") : "") + (ignore_collision != null ? ignore_collision.debug() : "") + (definitions != null ? definitions.debug() : ""));
        }
        final boolean forceAlong = force_along.asBoolean();
        final ListTag entityList = new ListTag();
        for (EntityTag entity : entities) {
            entity.spawnAt(originLocation);
            entityList.addObject(entity);
            if (!no_rotate) {
                NMSHandler.getEntityHelper().faceLocation(entity.getBukkitEntity(), (Location)destination);
            }
            if (!entity.isProjectile() || originEntity == null) continue;
            entity.setShooter(originEntity);
        }
        scriptEntry.addObject("pushed_entities", entityList);
        Position.mount(Conversion.convertEntities(entities));
        final EntityTag lastEntity = (EntityTag)entities.get(entities.size() - 1);
        final Vector v2 = destination.toVector();
        final Vector Origin = originLocation.toVector();
        final int prec = precision.asInt();
        BukkitRunnable task = new BukkitRunnable(){
            int runs = 0;
            LocationTag lastLocation;

            public void run() {
                if (this.runs < maxTicks && lastEntity.isValid()) {
                    Vector v1 = lastEntity.getLocation().toVector();
                    Vector v3 = v2.clone().subtract(v1).normalize();
                    if (forceAlong) {
                        Vector newDest = v2.clone().subtract(Origin).normalize().multiply((double)this.runs * speed / 20.0).add(Origin);
                        lastEntity.teleport(new Location(lastEntity.getLocation().getWorld(), newDest.getX(), newDest.getY(), newDest.getZ(), lastEntity.getLocation().getYaw(), lastEntity.getLocation().getPitch()));
                    }
                    this.runs += prec;
                    if (Math.abs(v2.getX() - v1.getX()) < 1.5 && Math.abs(v2.getY() - v1.getY()) < 1.5 && Math.abs(v2.getZ() - v1.getZ()) < 1.5) {
                        this.runs = maxTicks;
                        return;
                    }
                    Vector newVel = v3.multiply(speed);
                    lastEntity.setVelocity(newVel);
                    if (!(ignoreCollision || PushCommand.isSafeBlock(lastEntity.getLocation().add(v3)) && PushCommand.isSafeBlock(lastEntity.getLocation().add(newVel)))) {
                        this.runs = maxTicks;
                    }
                    if (no_damage && lastEntity.isLivingEntity()) {
                        lastEntity.getLivingEntity().setFallDistance(0.0f);
                    }
                    this.lastLocation = lastEntity.getLocation();
                } else {
                    this.cancel();
                    if (script != null) {
                        Consumer<ScriptQueue> configure = queue -> {
                            if (lastEntity.getLocation() != null) {
                                queue.addDefinition("location", lastEntity.getLocation());
                            } else {
                                queue.addDefinition("location", this.lastLocation);
                            }
                            queue.addDefinition("pushed_entities", entityList);
                            queue.addDefinition("last_entity", lastEntity);
                        };
                        ScriptUtilities.createAndStartQueue(script.getContainer(), null, scriptEntry.entryData, null, configure, null, null, definitions, scriptEntry);
                    }
                    scriptEntry.setFinished(true);
                }
            }
        };
        task.runTaskTimer((Plugin)Denizen.getInstance(), 0L, (long)prec);
    }

    public static boolean isSafeBlock(Location loc) {
        return loc.getBlockY() < 0 || loc.getBlockY() > 255 || !loc.getBlock().getType().isSolid();
    }
}

