/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class GroupCommand
extends AbstractCommand {
    public GroupCommand() {
        this.setName("group");
        this.setSyntax("group [add/remove/set] [<group>] (<world>)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (Depends.permissions == null) {
            throw new InvalidArgumentsException("Permissions not linked - is Vault improperly installed, or is there no permissions plugin?");
        }
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            if (scriptEntry.hasObject("group")) continue;
            scriptEntry.addObject("group", arg.asElement());
        }
        if (!Utilities.entryHasPlayer(scriptEntry) || !Utilities.getEntryPlayer(scriptEntry).isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify valid action!");
        }
        if (!scriptEntry.hasObject("group")) {
            throw new InvalidArgumentsException("Must specify a group name!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag action = scriptEntry.getElement("action");
        WorldTag world = (WorldTag)scriptEntry.getObjectTag("world");
        ElementTag group = scriptEntry.getElement("group");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), action.debug() + (world != null ? world.debug() : "") + group.debug());
        }
        World bukkitWorld = null;
        if (world != null) {
            bukkitWorld = world.getWorld();
        }
        OfflinePlayer player = Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer();
        boolean inGroup = Depends.permissions.playerInGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, group.asString());
        switch (Action.valueOf(action.asString().toUpperCase())) {
            case ADD: {
                if (inGroup) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Player " + player.getName() + " is already in group " + group);
                    break;
                }
                Depends.permissions.playerAddGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, group.asString());
                break;
            }
            case REMOVE: {
                if (!inGroup) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Player " + player.getName() + " is not in group " + group);
                    break;
                }
                Depends.permissions.playerRemoveGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, group.asString());
                break;
            }
            case SET: {
                for (String grp : Depends.permissions.getPlayerGroups(bukkitWorld == null ? null : bukkitWorld.getName(), player)) {
                    Depends.permissions.playerRemoveGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, grp);
                }
                Depends.permissions.playerAddGroup(bukkitWorld == null ? null : bukkitWorld.getName(), player, group.asString());
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        SET;

    }
}

