/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.core.CooldownCommand;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.List;
import org.bukkit.ChatColor;

public class InteractScriptHelper {
    public static boolean debugGet = true;

    public static InteractScriptContainer getInteractScript(NPCTag npc, PlayerTag player, Class<? extends AbstractTrigger> trigger) {
        InteractScriptContainer interactScript;
        String script;
        if (npc == null || player == null || trigger == null) {
            return null;
        }
        AssignmentScriptContainer assignmentScript = npc.getAssignmentTrait().getAssignment();
        if (assignmentScript == null) {
            return null;
        }
        if (!assignmentScript.contains("interact scripts")) {
            return null;
        }
        List<String> assignedScripts = assignmentScript.getStringList("interact scripts");
        if (assignedScripts.isEmpty()) {
            return null;
        }
        if (Debug.shouldDebug(assignmentScript) && debugGet) {
            Debug.log(Debug.DebugElement.Header, "Getting interact script: n@" + npc.getName() + "/p@" + player.getName());
        }
        if ((script = assignedScripts.get(0)).contains(" ") && Character.isDigit(script.charAt(0))) {
            Deprecations.interactScriptPriority.warn(assignmentScript);
            try {
                script = script.split(" ", 2)[1].replace("^", "");
            }
            catch (Exception e) {
                Debug.echoError("Invalid Interact assignment for '" + script + "'. Is the script name missing?");
                return null;
            }
        }
        if ((interactScript = (InteractScriptContainer)ScriptRegistry.getScriptContainer(script)) == null) {
            Debug.echoError("'" + script + "' is not a valid Interact Script. Is there a duplicate script by this name?");
            return null;
        }
        if (!CooldownCommand.checkCooldown(player, interactScript.getName()) && Debug.shouldDebug(interactScript) && debugGet) {
            Debug.log(ChatColor.GOLD + " ...but, isn't cooled down, yet! Skipping.");
            return null;
        }
        if (Debug.shouldDebug(assignmentScript) && debugGet) {
            Debug.log(Debug.DebugElement.Spacer, null);
        }
        if (Debug.shouldDebug(assignmentScript) && debugGet) {
            Debug.log("Interact script is " + script + ". Current step for this script is: " + InteractScriptHelper.getCurrentStep(player, script));
        }
        if (Debug.shouldDebug(interactScript) && debugGet) {
            Debug.log(Debug.DebugElement.Footer, "");
        }
        return interactScript;
    }

    public static String getCurrentStep(PlayerTag player, String scriptName) {
        if (scriptName == null) {
            return null;
        }
        ObjectTag step = player.getFlagTracker().getFlagValue("__interact_step." + scriptName);
        if (step != null) {
            return step.toString().toUpperCase();
        }
        return ScriptRegistry.getScriptContainerAs(scriptName, InteractScriptContainer.class).getDefaultStepName().toUpperCase();
    }
}

