/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;

public class BlockExplodesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockExplodesScriptEvent instance;
    public BlockExplodeEvent event;
    public List<Block> blocks;

    public BlockExplodesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("explodes")) {
            return false;
        }
        return this.couldMatchBlock(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!target.equals("block")) {
            boolean matched = false;
            for (Block block : this.blocks) {
                if (!this.tryMaterial(new MaterialTag(block.getType()), target)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return false;
            }
        }
        if (!this.runInCheck(path, this.blocks.get(0).getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockExplodes";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (ArgumentHelper.matchesDouble(determination)) {
            this.event.setYield(Float.parseFloat(determination));
            return true;
        }
        if (ListTag.matches(determination)) {
            this.event.blockList().clear();
            for (String loc : ListTag.valueOf(determination, this.getTagContext(path))) {
                LocationTag location = LocationTag.valueOf(loc, this.getTagContext(path));
                if (location == null) {
                    Debug.echoError("Invalid location '" + loc + "' check [" + this.getName() + "]: '  for " + path.container.getName());
                    continue;
                }
                this.event.blockList().add(location.getWorld().getBlockAt((Location)location));
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("blocks")) {
            ListTag blocks = new ListTag();
            for (Block block : this.blocks) {
                blocks.addObject(new LocationTag(block.getLocation()));
            }
            return blocks;
        }
        if (name.equals("strength")) {
            return new ElementTag(this.event.getYield());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockExplodes(BlockExplodeEvent event) {
        this.blocks = event.blockList();
        this.event = event;
        this.fire((Event)event);
    }
}

