/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class EntityDamagedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityDamagedScriptEvent instance;
    public EntityTag entity;
    public ElementTag cause;
    public EntityTag damager;
    public EntityTag projectile;
    public ItemTag held;
    public EntityDamageEvent event;

    public EntityDamagedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (cmd.equals("damaged")) {
            if (path.eventArgLowerAt(0).equals("vehicle")) {
                return false;
            }
        } else if (cmd.equals("damages")) {
            if (!this.couldMatchEntity(path.eventArgLowerAt(2))) {
                return false;
            }
            if (path.eventArgLowerAt(2).equals("vehicle")) {
                return false;
            }
        } else {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target;
        String cmd = path.eventArgLowerAt(1);
        String attacker = cmd.equals("damages") ? path.eventArgLowerAt(0) : (path.eventArgLowerAt(2).equals("by") ? path.eventArgLowerAt(3) : "");
        String string = target = cmd.equals("damages") ? path.eventArgLowerAt(2) : path.eventArgLowerAt(0);
        if (!attacker.isEmpty() && (this.damager != null ? !this.cause.asString().equals(attacker) && !this.tryEntity(this.projectile, attacker) && !this.tryEntity(this.damager, attacker) : !this.cause.asString().equals(attacker))) {
            return false;
        }
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!this.runWithCheck(path, this.held)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityDamaged";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isDouble()) {
            this.event.setDamage(((ElementTag)determinationObj).asDouble());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.damager != null && this.damager.isPlayer() ? this.damager.getDenizenPlayer() : (this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null), this.damager != null && this.damager.isCitizensNPC() ? this.damager.getDenizenNPC() : (this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null));
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damage")) {
            return new ElementTag(this.event.getDamage());
        }
        if (name.equals("final_damage")) {
            return new ElementTag(this.event.getFinalDamage());
        }
        if (name.equals("cause")) {
            return this.cause;
        }
        if (name.equals("damager") && this.damager != null) {
            return this.damager.getDenizenObject();
        }
        if (name.equals("projectile") && this.projectile != null) {
            return this.projectile.getDenizenObject();
        }
        if (name.equals("damage_type_map")) {
            MapTag map = new MapTag();
            for (EntityDamageEvent.DamageModifier dm : EntityDamageEvent.DamageModifier.values()) {
                map.putObject(dm.name(), new ElementTag(this.event.getDamage(dm)));
            }
            return map;
        }
        if (name.startsWith("damage_")) {
            Deprecations.damageEventTypeMap.warn();
            for (EntityDamageEvent.DamageModifier dm : EntityDamageEvent.DamageModifier.values()) {
                if (!name.equals("damage_" + CoreUtilities.toLowerCase(dm.name()))) continue;
                return new ElementTag(this.event.getDamage(dm));
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityDamaged(EntityDamageEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.cause = new ElementTag(CoreUtilities.toLowerCase(event.getCause().name()));
        this.damager = null;
        this.projectile = null;
        this.held = null;
        if (event instanceof EntityDamageByEntityEvent) {
            this.damager = new EntityTag(((EntityDamageByEntityEvent)event).getDamager());
            if (this.damager.isProjectile()) {
                this.projectile = this.damager;
                if (this.damager.hasShooter()) {
                    this.damager = this.damager.getShooter();
                }
            }
            if (this.damager != null) {
                this.held = this.damager.getItemInHand();
                if (this.held != null) {
                    this.held.setAmount(1);
                }
            }
        }
        this.event = event;
        this.fire((Event)event);
    }
}

