/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.item;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;

public class ItemEnchantedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ItemEnchantedScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    public InventoryTag inventory;
    public ItemTag item;
    public ElementTag button;
    public int cost;
    public EnchantItemEvent event;

    public ItemEnchantedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("enchanted")) {
            return false;
        }
        return this.couldMatchItem(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String itemTest = path.eventArgLowerAt(0);
        if (!itemTest.equals("item") && !this.tryItem(this.item, itemTest)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "ItemEnchanted";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            if (((ElementTag)determinationObj).isInt()) {
                this.cost = ((ElementTag)determinationObj).asInt();
                this.event.setExpLevelCost(this.cost);
                return true;
            }
            String determination = determinationObj.toString();
            String lower = CoreUtilities.toLowerCase(determination);
            if (lower.startsWith("result:")) {
                String itemText = determination.substring("result:".length());
                this.item = ItemTag.valueOf(itemText, path.container);
                this.event.getItem().setItemMeta(this.item.getItemMeta());
                return true;
            }
            if (lower.startsWith("enchants:")) {
                this.event.getEnchantsToAdd().clear();
                String itemText = determination.substring("enchants:".length());
                if (itemText.startsWith("map@")) {
                    MapTag map = MapTag.valueOf(itemText, this.getTagContext(path));
                    for (Map.Entry<StringHolder, ObjectTag> enchantments : map.map.entrySet()) {
                        this.event.getEnchantsToAdd().put(Utilities.getEnchantmentByName(enchantments.getKey().low), enchantments.getValue().asType(ElementTag.class, this.getTagContext(path)).asInt());
                    }
                } else {
                    ItemTag enchantsRes = ItemTag.valueOf(itemText, path.container);
                    this.event.getEnchantsToAdd().putAll(enchantsRes.getItemMeta().getEnchants());
                }
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("inventory")) {
            return this.inventory;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("button")) {
            return this.button;
        }
        if (name.equals("cost")) {
            return new ElementTag(this.cost);
        }
        if (name.equals("enchants")) {
            MapTag map = new MapTag();
            for (Map.Entry enchant : this.event.getEnchantsToAdd().entrySet()) {
                map.putObject(((Enchantment)enchant.getKey()).getKey().getKey(), new ElementTag((Integer)enchant.getValue()));
            }
            return map;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onItemEnchanted(EnchantItemEvent event) {
        this.entity = new EntityTag((Entity)event.getEnchanter());
        this.location = new LocationTag(event.getEnchantBlock().getLocation());
        this.inventory = InventoryTag.mirrorBukkitInventory(event.getInventory());
        this.item = new ItemTag(event.getItem());
        this.button = new ElementTag(event.whichButton());
        this.cost = event.getExpLevelCost();
        this.event = event;
        this.fire((Event)event);
    }
}

