/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;

public class EntityCustomName
implements Property {
    public static final String[] handledTags = new String[]{"custom_name_visible", "custom_name"};
    public static final String[] handledMechs = new String[]{"custom_name_visibility", "custom_name_visible", "custom_name"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag;
    }

    public static EntityCustomName getFrom(ObjectTag entity) {
        if (!EntityCustomName.describes(entity)) {
            return null;
        }
        return new EntityCustomName((EntityTag)entity);
    }

    private EntityCustomName(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return this.entity.getBukkitEntity().getCustomName();
    }

    @Override
    public String getPropertyId() {
        return "custom_name";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("custom_name_visible") || attribute.startsWith("custom_name.visible")) {
            int fulfilled = 1;
            if (attribute.startsWith("custom_name.visible")) {
                fulfilled = 2;
            }
            return new ElementTag(this.entity.getBukkitEntity().isCustomNameVisible()).getObjectAttribute(attribute.fulfill(fulfilled));
        }
        if (attribute.startsWith("custom_name")) {
            String name = this.entity.getBukkitEntity().getCustomName();
            if (name == null) {
                return null;
            }
            return new ElementTag(name).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("custom_name_visibility") || mechanism.matches("custom_name_visible")) && mechanism.requireBoolean()) {
            this.entity.getBukkitEntity().setCustomNameVisible(mechanism.getValue().asBoolean());
        } else if (mechanism.matches("custom_name")) {
            this.entity.getBukkitEntity().setCustomName(CoreUtilities.clearNBSPs(mechanism.getValue().asString()));
        }
    }
}

