/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Axis;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.Rotatable;
import org.bukkit.util.Vector;

public class MaterialDirectional
implements Property {
    public static final String[] handledMechs = new String[]{"direction"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData().data;
        return data instanceof Directional || data instanceof Orientable || data instanceof Rotatable || data instanceof Rail;
    }

    public static MaterialDirectional getFrom(ObjectTag _material) {
        if (!MaterialDirectional.describes(_material)) {
            return null;
        }
        return new MaterialDirectional((MaterialTag)_material);
    }

    private MaterialDirectional(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("valid_directions", (attribute, material) -> {
            ListTag toReturn = new ListTag();
            if (material.isOrientable()) {
                for (Axis axis : material.getOrientable().getAxes()) {
                    toReturn.add(axis.name());
                }
            } else if (material.isRail()) {
                for (Rail.Shape shape : material.getRail().getShapes()) {
                    toReturn.add(shape.name());
                }
            } else if (material.isDirectional()) {
                for (BlockFace face : material.getDirectional().getFaces()) {
                    toReturn.add(face.name());
                }
            } else {
                return null;
            }
            return toReturn;
        }, new String[0]);
        PropertyParser.registerTag("direction", (attribute, material) -> new ElementTag(material.getDirectionName()), new String[0]);
    }

    public Vector getDirectionVector() {
        if (this.isOrientable()) {
            switch (this.getOrientable().getAxis()) {
                case X: {
                    return new Vector(1, 0, 0);
                }
                case Y: {
                    return new Vector(0, 1, 0);
                }
            }
            return new Vector(0, 0, 1);
        }
        if (this.isRotatable()) {
            return this.getRotatable().getRotation().getDirection();
        }
        if (this.isRail()) {
            switch (this.getRail().getShape()) {
                case ASCENDING_EAST: {
                    return new Vector(1, 1, 0);
                }
                case ASCENDING_NORTH: {
                    return new Vector(0, 1, -1);
                }
                case ASCENDING_SOUTH: {
                    return new Vector(0, 1, 1);
                }
                case ASCENDING_WEST: {
                    return new Vector(-1, 1, 0);
                }
                case EAST_WEST: {
                    return new Vector(1, 0, 0);
                }
                case NORTH_EAST: {
                    return new Vector(1, 0, -1);
                }
                case NORTH_SOUTH: {
                    return new Vector(0, 0, 1);
                }
                case NORTH_WEST: {
                    return new Vector(-1, 0, -1);
                }
                case SOUTH_EAST: {
                    return new Vector(1, 0, 1);
                }
                case SOUTH_WEST: {
                    return new Vector(-1, 0, 1);
                }
            }
            return null;
        }
        return this.getDirectional().getFacing().getDirection();
    }

    public String getDirectionName() {
        if (this.isOrientable()) {
            return this.getOrientable().getAxis().name();
        }
        if (this.isRotatable()) {
            return this.getRotatable().getRotation().name();
        }
        if (this.isRail()) {
            return this.getRail().getShape().name();
        }
        return this.getDirectional().getFacing().name();
    }

    public boolean isOrientable() {
        return this.material.getModernData().data instanceof Orientable;
    }

    public boolean isRotatable() {
        return this.material.getModernData().data instanceof Rotatable;
    }

    public boolean isDirectional() {
        return this.material.getModernData().data instanceof Directional;
    }

    public boolean isRail() {
        return this.material.getModernData().data instanceof Rail;
    }

    public Orientable getOrientable() {
        return (Orientable)this.material.getModernData().data;
    }

    public Rotatable getRotatable() {
        return (Rotatable)this.material.getModernData().data;
    }

    public Directional getDirectional() {
        return (Directional)this.material.getModernData().data;
    }

    public Rail getRail() {
        return (Rail)this.material.getModernData().data;
    }

    public void setFacing(BlockFace face) {
        if (this.isOrientable()) {
            Vector vec = face.getDirection();
            Axis axis = vec.getX() >= 0.5 ? Axis.X : (vec.getY() >= 0.5 ? Axis.Y : Axis.Z);
            this.getOrientable().setAxis(axis);
        } else if (this.isRotatable()) {
            this.getRotatable().setRotation(face);
        } else if (this.isRail()) {
            switch (face) {
                case EAST: 
                case WEST: {
                    this.getRail().setShape(Rail.Shape.EAST_WEST);
                }
                case NORTH: 
                case SOUTH: {
                    this.getRail().setShape(Rail.Shape.NORTH_SOUTH);
                }
                case NORTH_EAST: {
                    this.getRail().setShape(Rail.Shape.NORTH_EAST);
                }
                case NORTH_WEST: {
                    this.getRail().setShape(Rail.Shape.NORTH_WEST);
                }
                case SOUTH_EAST: {
                    this.getRail().setShape(Rail.Shape.SOUTH_EAST);
                }
                case SOUTH_WEST: {
                    this.getRail().setShape(Rail.Shape.SOUTH_WEST);
                }
            }
            Debug.echoError("Unsupported rail direction '" + face + "'.");
        } else if (this.isDirectional()) {
            this.getDirectional().setFacing(face);
        }
    }

    @Override
    public String getPropertyString() {
        return this.getDirectionName();
    }

    @Override
    public String getPropertyId() {
        return "direction";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("direction")) {
            if (this.isOrientable() && mechanism.requireEnum(false, (Enum<?>[])Axis.values())) {
                this.getOrientable().setAxis(Axis.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isRail() && mechanism.requireEnum(false, (Enum<?>[])Rail.Shape.values())) {
                this.getRail().setShape(Rail.Shape.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (mechanism.requireEnum(false, (Enum<?>[])BlockFace.values())) {
                this.setFacing(BlockFace.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else {
                mechanism.echoError("MaterialTag.Direction mechanism has bad input: directional value '" + mechanism.getValue().asString() + "' is invalid.");
            }
        }
    }
}

