/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class LookCommand
extends AbstractCommand {
    public static HashMap<UUID, BukkitTask> lookTasks = new HashMap();

    public LookCommand() {
        this.setName("look");
        this.setSyntax("look (<entity>|...) [<location>/cancel] (duration:<duration>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("cancel") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("cancel") && !scriptEntry.hasObject("location") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class) && arg.matchesPrefix("duration", "d")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            scriptEntry.defaultObject("entities", Utilities.entryDefaultEntityList(scriptEntry, false));
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify a location or 'cancel'!");
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify an entity!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Object task;
        final LocationTag loc = (LocationTag)scriptEntry.getObjectTag("location");
        List entities = (List)scriptEntry.getObject("entities");
        final DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ElementTag cancel = scriptEntry.getElement("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (cancel != null ? cancel.debug() : loc.debug()) + ArgumentHelper.debugObj("entities", entities.toString()));
        }
        for (final EntityTag entity : entities) {
            if (!entity.isSpawned() || (task = lookTasks.remove(entity.getUUID())) == null) continue;
            task.cancel();
        }
        if (cancel != null && cancel.asBoolean()) {
            return;
        }
        for (final EntityTag entity : entities) {
            if (!entity.isSpawned()) continue;
            NMSHandler.getEntityHelper().faceLocation(entity.getBukkitEntity(), (Location)loc);
        }
        if (duration != null && duration.getTicks() > 2L) {
            for (final EntityTag entity : entities) {
                task = new BukkitRunnable(){
                    long bounces = 0L;

                    public void run() {
                        this.bounces += 2L;
                        if (this.bounces > duration.getTicks()) {
                            this.cancel();
                            lookTasks.remove(entity.getUUID());
                            return;
                        }
                        if (entity.isSpawned()) {
                            NMSHandler.getEntityHelper().faceLocation(entity.getBukkitEntity(), (Location)loc);
                        }
                    }
                };
                BukkitTask newTask = task.runTaskTimer((Plugin)Denizen.getInstance(), 0L, 2L);
                lookTasks.put(entity.getUUID(), newTask);
            }
        }
    }
}

