/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class FakeEntity {
    public static final Map<UUID, FakeEntityMap> playersToEntities = new HashMap<UUID, FakeEntityMap>();
    public static final Map<UUID, FakeEntity> idsToEntities = new HashMap<UUID, FakeEntity>();
    public List<PlayerTag> players;
    public int id;
    public EntityTag entity;
    public LocationTag location;
    public BukkitTask currentTask = null;
    public Consumer<PlayerTag> triggerSpawnPacket;
    public Runnable triggerUpdatePacket;
    public Runnable triggerDestroyPacket;
    public UUID overrideUUID;

    public static FakeEntity getFakeEntityFor(UUID uuid, int id) {
        FakeEntityMap map = playersToEntities.get(uuid);
        if (map == null) {
            return null;
        }
        return map.byId.get(id);
    }

    public FakeEntity(List<PlayerTag> player, LocationTag location, int id) {
        this.players = player;
        this.location = location;
        this.id = id;
    }

    public static FakeEntity showFakeEntityTo(List<PlayerTag> players, EntityTag typeToSpawn, LocationTag location, DurationTag duration) {
        FakeEntity fakeEntity = NMSHandler.getPlayerHelper().sendEntitySpawn(players, typeToSpawn.getEntityType(), location, typeToSpawn.getWaitingMechanisms(), -1, null, true);
        idsToEntities.put(fakeEntity.overrideUUID == null ? fakeEntity.entity.getUUID() : fakeEntity.overrideUUID, fakeEntity);
        for (PlayerTag player : players) {
            UUID uuid = player.getPlayerEntity().getUniqueId();
            FakeEntityMap playerEntities = playersToEntities.get(uuid);
            if (playerEntities == null) {
                playerEntities = new FakeEntityMap();
                playersToEntities.put(uuid, playerEntities);
            }
            playerEntities.byId.put(fakeEntity.id, fakeEntity);
        }
        fakeEntity.updateEntity(fakeEntity.entity, duration);
        return fakeEntity;
    }

    public void cancelEntity() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
        idsToEntities.remove(this.overrideUUID == null ? this.entity.getUUID() : this.overrideUUID);
        if (this.triggerDestroyPacket != null) {
            this.triggerDestroyPacket.run();
        } else {
            for (PlayerTag player : this.players) {
                if (!player.isOnline()) continue;
                NMSHandler.getPlayerHelper().sendEntityDestroy(player.getPlayerEntity(), this.entity.getBukkitEntity());
            }
        }
        for (PlayerTag player : this.players) {
            FakeEntityMap mapping = playersToEntities.get(player.getUUID());
            mapping.remove(this);
        }
        this.entity.isFakeValid = false;
    }

    private void updateEntity(EntityTag entity, DurationTag duration) {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.entity = entity;
        if (duration != null && duration.getTicks() > 0L) {
            this.currentTask = new BukkitRunnable(){

                public void run() {
                    FakeEntity.this.currentTask = null;
                    FakeEntity.this.cancelEntity();
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), duration.getTicks());
        }
    }

    public static class FakeEntityMap {
        public Map<Integer, FakeEntity> byId = new HashMap<Integer, FakeEntity>();

        public void remove(FakeEntity entity) {
            this.byId.remove(entity.id);
        }
    }
}

