/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.function.Consumer;

public class RunCommand
extends AbstractCommand
implements Holdable {
    public RunCommand() {
        this.setName("run");
        this.setSyntax("run [<script>/locally] (path:<name>) (def:<element>|...) (id:<name>) (speed:<value>/instantly) (delay:<value>)");
        this.setRequiredArguments(1, 6);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesPrefix("i", "id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("d", "def", "define", "c", "context")) {
                scriptEntry.addObject("definitions", arg.asElement());
                continue;
            }
            if (arg.matches("instant", "instantly")) {
                scriptEntry.addObject("instant", new ElementTag(true));
                continue;
            }
            if (arg.matchesPrefix("delay") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if (arg.matches("local", "locally")) {
                scriptEntry.addObject("local", new ElementTag("true"));
                scriptEntry.addObject("script", scriptEntry.getScript());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && !arg.matchesPrefix("p", "path")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrefix("speed") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("speed", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("path")) {
                ScriptTag script;
                int dotIndex;
                String path = arg.asElement().asString();
                if (!scriptEntry.hasObject("script") && (dotIndex = path.indexOf(46)) > 0 && (script = new ScriptTag(path.substring(0, dotIndex))).isValid()) {
                    scriptEntry.addObject("script", script);
                    path = path.substring(dotIndex + 1);
                }
                scriptEntry.addObject("path", new ElementTag(path));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!(scriptEntry.hasObject("script") || scriptEntry.hasObject("local") && scriptEntry.getScript() != null)) {
            throw new InvalidArgumentsException("Must define a SCRIPT to be run.");
        }
        if (!scriptEntry.hasObject("path") && scriptEntry.hasObject("local")) {
            throw new InvalidArgumentsException("Must specify a PATH.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String path;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (scriptEntry.hasObject("script") ? scriptEntry.getObjectTag("script").debug() : scriptEntry.getScript().debug()) + (scriptEntry.hasObject("instant") ? scriptEntry.getObjectTag("instant").debug() : "") + (scriptEntry.hasObject("path") ? scriptEntry.getElement("path").debug() : "") + (scriptEntry.hasObject("local") ? scriptEntry.getElement("local").debug() : "") + (scriptEntry.hasObject("delay") ? scriptEntry.getObjectTag("delay").debug() : "") + (scriptEntry.hasObject("id") ? scriptEntry.getObjectTag("id").debug() : "") + (scriptEntry.hasObject("definitions") ? scriptEntry.getObjectTag("definitions").debug() : "") + (scriptEntry.hasObject("speed") ? scriptEntry.getObjectTag("speed").debug() : ""));
        }
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        if (scriptEntry.hasObject("local")) {
            script = scriptEntry.getScript();
        }
        String string = path = scriptEntry.hasObject("path") ? scriptEntry.getElement("path").asString() : null;
        if (script == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Script run failed (invalid script name)!");
            return;
        }
        if (!(path == null || script.getContainer().contains(path) && script.getContainer().getContents().isList(path))) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Script run failed (invalid path)!");
            return;
        }
        String id = scriptEntry.hasObject("id") ? "FORCE:" + scriptEntry.getElement("id").asString() : null;
        DurationTag speed = null;
        if (scriptEntry.hasObject("instant")) {
            speed = new DurationTag(0);
        } else if (scriptEntry.hasObject("speed")) {
            speed = (DurationTag)scriptEntry.getObjectTag("speed");
        }
        ListTag definitions = null;
        if (scriptEntry.hasObject("definitions")) {
            ElementTag raw_definitions = scriptEntry.getElement("definitions");
            definitions = ListTag.valueOf(raw_definitions.asString(), scriptEntry.getContext());
        }
        Consumer<ScriptQueue> configure = queue -> {
            if (scriptEntry.hasObject("delay")) {
                queue.delayUntil(DenizenCore.serverTimeMillis + ((DurationTag)scriptEntry.getObject("delay")).getMillis());
            }
            if (scriptEntry.shouldWaitFor()) {
                queue.callBack(() -> scriptEntry.setFinished(true));
            }
            scriptEntry.addObject("created_queue", new QueueTag((ScriptQueue)queue));
            queue.procedural = scriptEntry.getResidingQueue().procedural;
        };
        ScriptQueue result = ScriptUtilities.createAndStartQueue(script.getContainer(), path, scriptEntry.entryData, null, configure, speed, id, definitions, scriptEntry);
        if (result == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Script run failed!");
            return;
        }
    }
}

