/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WeatherCommand
extends AbstractCommand {
    public HashMap<UUID, Integer> resetTasks = new HashMap();

    public WeatherCommand() {
        this.setName("weather");
        this.setSyntax("weather ({global}/player) [sunny/storm/thunder/reset] (<world>) (reset:<duration>)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesEnum(Value.values())) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("reset_after") && arg.matchesPrefix("reset") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("reset_after", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
        scriptEntry.defaultObject("type", new Object[]{Type.GLOBAL});
        scriptEntry.defaultObject("world", Utilities.entryDefaultWorld(scriptEntry, false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Value value = Value.valueOf(scriptEntry.getElement("value").asString().toUpperCase());
        WorldTag world = (WorldTag)scriptEntry.getObjectTag("world");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        DurationTag resetAfter = (DurationTag)scriptEntry.getObjectTag("reset_after");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), ArgumentHelper.debugObj("type", type.name()) + (type.name().equalsIgnoreCase("player") ? ArgumentHelper.debugObj("player", Utilities.getEntryPlayer(scriptEntry)) : "") + (type.name().equalsIgnoreCase("global") ? ArgumentHelper.debugObj("world", world) : "") + (resetAfter != null ? resetAfter.debug() : "") + ArgumentHelper.debugObj("value", (Object)value));
        }
        if (type.equals((Object)Type.GLOBAL)) {
            switch (value) {
                case SUNNY: {
                    world.getWorld().setStorm(false);
                    world.getWorld().setThundering(false);
                    break;
                }
                case STORM: {
                    world.getWorld().setStorm(true);
                    break;
                }
                case THUNDER: {
                    world.getWorld().setStorm(true);
                    world.getWorld().setThundering(true);
                    break;
                }
                case RESET: {
                    Debug.echoError("Cannot RESET global weather!");
                }
            }
        } else {
            Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
            Integer existingTask = this.resetTasks.get(player.getUniqueId());
            if (existingTask != null) {
                Bukkit.getScheduler().cancelTask(existingTask.intValue());
                this.resetTasks.remove(player.getUniqueId());
            }
            if (value == Value.SUNNY) {
                player.setPlayerWeather(WeatherType.CLEAR);
            } else if (value == Value.STORM || value == Value.THUNDER) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            } else if (value == Value.RESET) {
                player.resetPlayerWeather();
            }
            if (resetAfter != null) {
                int newTask = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> ((Player)player).resetPlayerWeather(), resetAfter.getTicks());
                this.resetTasks.put(player.getUniqueId(), newTask);
            }
        }
    }

    private static enum Value {
        SUNNY,
        STORM,
        THUNDER,
        RESET;

    }

    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

