/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.commands.queue.DetermineCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatTrigger
extends AbstractTrigger
implements Listener {
    static final Pattern triggerPattern = Pattern.compile("/([^/]*)/");

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }

    public ChatContext process(Player player, String message) {
        NPCTag npc = Utilities.getClosestNPC_ChatTrigger(player.getLocation(), 25);
        PlayerTag denizenPlayer = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
        if (Debug.verbose) {
            Debug.log("Processing chat trigger: valid npc? " + (npc != null));
        }
        if (npc == null) {
            return new ChatContext(false);
        }
        if (Debug.verbose) {
            Debug.log("Has trait?  " + npc.getCitizen().hasTrait(TriggerTrait.class));
        }
        if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
            return new ChatContext(false);
        }
        if (Debug.verbose) {
            Debug.log("enabled? " + ((TriggerTrait)npc.getCitizen().getOrAddTrait(TriggerTrait.class)).isEnabled(this.name));
        }
        if (!((TriggerTrait)npc.getCitizen().getOrAddTrait(TriggerTrait.class)).isEnabled(this.name)) {
            return new ChatContext(false);
        }
        if (npc.getTriggerTrait().getRadius(this.name) < npc.getLocation().distance(player.getLocation())) {
            if (Debug.verbose) {
                Debug.log("Not in range");
            }
            return new ChatContext(false);
        }
        if (Settings.chatMustSeeNPC() && !player.hasLineOfSight(npc.getEntity())) {
            if (Debug.verbose) {
                Debug.log("no LOS");
            }
            return new ChatContext(false);
        }
        if (Settings.chatMustLookAtNPC() && !NMSHandler.getEntityHelper().isFacingEntity((Entity)player, npc.getEntity(), 45.0f)) {
            if (Debug.verbose) {
                Debug.log("Not facing");
            }
            return new ChatContext(false);
        }
        boolean ret = false;
        InteractScriptContainer script = npc.getInteractScript(denizenPlayer, ChatTrigger.class);
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("message", new ElementTag(message));
        TriggerTrait.TriggerContext trigger = npc.getTriggerTrait().trigger(this, denizenPlayer, context);
        if (trigger.hasDetermination() && trigger.getDetermination().equalsIgnoreCase("cancelled")) {
            if (Debug.verbose) {
                Debug.log("Cancelled");
            }
            return new ChatContext(true);
        }
        if (!trigger.wasTriggered()) {
            if (Settings.chatGloballyIfUninteractable()) {
                Debug.echoDebug((Debuggable)script, ChatColor.YELLOW + "Resuming. " + ChatColor.WHITE + "The NPC is currently cooling down or engaged.");
                return new ChatContext(false);
            }
            ret = true;
        }
        if (trigger.hasDetermination()) {
            message = trigger.getDetermination();
        }
        if (script == null) {
            if (Debug.verbose) {
                Debug.log("null script");
            }
            return new ChatContext(message, false);
        }
        Debug.report((Debuggable)script, this.name, ArgumentHelper.debugObj("Player", player.getName()) + ArgumentHelper.debugObj("NPC", npc.toString()) + ArgumentHelper.debugObj("Radius(Max)", npc.getLocation().distance(player.getLocation()) + "(" + npc.getTriggerTrait().getRadius(this.name) + ")") + ArgumentHelper.debugObj("Trigger text", message) + ArgumentHelper.debugObj("LOS", String.valueOf(player.hasLineOfSight(npc.getEntity()))) + ArgumentHelper.debugObj("Facing", String.valueOf(NMSHandler.getEntityHelper().isFacingEntity((Entity)player, npc.getEntity(), 45.0f))));
        String step = InteractScriptHelper.getCurrentStep(denizenPlayer, script.getName());
        if (!script.containsTriggerInStep(step, ChatTrigger.class)) {
            if (!Settings.chatGloballyIfNoChatTriggers()) {
                Debug.echoDebug((Debuggable)script, player.getName() + " says to " + npc.getNicknameTrait().getNickname() + ", " + message);
                return new ChatContext(false);
            }
            if (Debug.verbose) {
                Debug.log("No trigger in step, chatting globally");
            }
            return new ChatContext(message, ret);
        }
        String id = null;
        boolean matched = false;
        String replacementText = null;
        String regexId = null;
        String regexMessage = null;
        String messageLow = CoreUtilities.toLowerCase(message);
        TreeMap<String, String> idMap = new TreeMap<String, String>(script.getIdMapFor(ChatTrigger.class, denizenPlayer));
        if (!idMap.isEmpty()) {
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(idMap.entrySet());
            entries.sort((o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey());
            });
            for (Map.Entry entry : entries) {
                String triggerText = TagManager.tag((String)entry.getValue(), new BukkitTagContext(denizenPlayer, npc, null, false, null));
                Matcher matcher = triggerPattern.matcher(triggerText);
                while (matcher.find()) {
                    String keyword = TagManager.tag(matcher.group().replace("/", ""), new BukkitTagContext(denizenPlayer, npc, null, false, null));
                    String[] split = keyword.split("\\\\\\+REPLACE:", 2);
                    String replace = null;
                    if (split.length == 2) {
                        keyword = split[0];
                        replace = split[1];
                    }
                    String keywordLow = CoreUtilities.toLowerCase(keyword);
                    if (regexId == null && keywordLow.startsWith("regex:")) {
                        Pattern pattern = Pattern.compile(keyword.substring(6));
                        Matcher m = pattern.matcher(message);
                        if (!m.find()) continue;
                        regexId = (String)entry.getKey();
                        regexMessage = triggerText.replace(matcher.group(), m.group());
                        context.put("keyword", new ElementTag(m.group()));
                        if (replace == null) continue;
                        regexMessage = replace;
                        continue;
                    }
                    if (keyword.contains("|")) {
                        for (String subkeyword : CoreUtilities.split(keyword, '|')) {
                            if (!messageLow.contains(CoreUtilities.toLowerCase(subkeyword))) continue;
                            id = (String)entry.getKey();
                            replacementText = triggerText.replace(matcher.group(), subkeyword);
                            matched = true;
                            context.put("keyword", new ElementTag(subkeyword));
                            if (replace == null) continue;
                            replacementText = replace;
                        }
                        continue;
                    }
                    if (keyword.equals("*")) {
                        id = (String)entry.getKey();
                        replacementText = triggerText.replace("/*/", message);
                        matched = true;
                        if (replace == null) continue;
                        replacementText = replace;
                        continue;
                    }
                    if (keywordLow.startsWith("strict:") && messageLow.equals(keywordLow.substring("strict:".length()))) {
                        id = (String)entry.getKey();
                        replacementText = triggerText.replace(matcher.group(), keyword.substring("strict:".length()));
                        matched = true;
                        if (replace == null) continue;
                        replacementText = replace;
                        continue;
                    }
                    if (!messageLow.contains(keywordLow)) continue;
                    id = (String)entry.getKey();
                    replacementText = triggerText.replace(matcher.group(), keyword);
                    matched = true;
                    if (replace == null) continue;
                    replacementText = replace;
                }
                if (!matched) continue;
                break;
            }
        }
        if (!matched && regexId != null) {
            id = regexId;
            replacementText = regexMessage;
        }
        String showNormalChat = script.getString("STEPS." + step + ".CHAT TRIGGER." + id + ".SHOW AS NORMAL CHAT", "false");
        if (id != null) {
            String hideTriggerMessage = script.getString("STEPS." + step + ".CHAT TRIGGER." + id + ".HIDE TRIGGER MESSAGE", "false");
            if (!hideTriggerMessage.equalsIgnoreCase("true")) {
                Utilities.talkToNPC(replacementText, denizenPlayer, npc, Settings.chatToNpcOverhearingRange(), new ScriptTag(script));
            }
            this.parse(npc, denizenPlayer, script, id, context);
            if (Debug.verbose) {
                Debug.log("chat to NPC");
            }
            return new ChatContext(!showNormalChat.equalsIgnoreCase("true"));
        }
        if (!Settings.chatGloballyIfFailedChatTriggers()) {
            Utilities.talkToNPC(message, denizenPlayer, npc, Settings.chatToNpcOverhearingRange(), new ScriptTag(script));
            if (Debug.verbose) {
                Debug.log("Chat globally");
            }
            return new ChatContext(!showNormalChat.equalsIgnoreCase("true"));
        }
        if (Debug.verbose) {
            Debug.log("Finished calculating");
        }
        return new ChatContext(message, ret);
    }

    @EventHandler
    public void asyncChatTrigger(AsyncPlayerChatEvent event) {
        if (Debug.verbose) {
            Debug.log("Chat trigger seen, cancelled: " + event.isCancelled() + ", chatasync: " + Settings.chatAsynchronous());
        }
        if (event.isCancelled()) {
            return;
        }
        if (!Settings.chatAsynchronous()) {
            return;
        }
        if (!event.isAsynchronous()) {
            this.syncChatTrigger(new PlayerChatEvent(event.getPlayer(), event.getMessage(), event.getFormat(), event.getRecipients()));
            return;
        }
        FutureTask<ChatContext> futureTask = new FutureTask<ChatContext>(() -> this.process(event.getPlayer(), event.getMessage()));
        Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), futureTask);
        try {
            ChatContext context = futureTask.get();
            if (context.wasTriggered()) {
                event.setCancelled(true);
            }
            if (context.hasChanges()) {
                event.setMessage(context.getChanges());
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
    }

    @EventHandler
    public void syncChatTrigger(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (Settings.chatAsynchronous()) {
            return;
        }
        ChatContext chat = this.process(event.getPlayer(), event.getMessage());
        if (chat.wasTriggered()) {
            event.setCancelled(true);
        }
        if (chat.hasChanges()) {
            event.setMessage(chat.getChanges());
        }
    }

    public class ChatContext {
        String changed_text;
        boolean triggered;

        public ChatContext(boolean triggered) {
            this.triggered = triggered;
        }

        public ChatContext(String changed_text, boolean triggered) {
            this.changed_text = changed_text;
            this.triggered = triggered;
        }

        public boolean hasChanges() {
            return this.changed_text != null;
        }

        public String getChanges() {
            return this.changed_text != null ? this.changed_text : DetermineCommand.DETERMINE_NONE;
        }

        public boolean wasTriggered() {
            return this.triggered;
        }
    }
}

