/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms;

import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.AnimationHelper;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.abstracts.ParticleHelper;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.interfaces.ChunkHelper;
import com.denizenscript.denizen.nms.interfaces.CustomEntityHelper;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.interfaces.SoundHelper;
import com.denizenscript.denizen.nms.interfaces.WorldHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.utilities.packets.DenizenPacketHandler;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.util.Map;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class NMSHandler {
    private static NMSHandler instance;
    private static NMSVersion version;
    private static JavaPlugin javaPlugin;
    public static boolean debugPackets;
    public AdvancementHelper advancementHelper;
    public AnimationHelper animationHelper;
    public BlockHelper blockHelper;
    public ChunkHelper chunkHelper;
    public CustomEntityHelper customEntityHelper;
    public EntityHelper entityHelper;
    public FishingHelper fishingHelper;
    public ItemHelper itemHelper;
    public SoundHelper soundHelper;
    public PacketHelper packetHelper;
    public ParticleHelper particleHelper;
    public PlayerHelper playerHelper;
    public WorldHelper worldHelper;

    public static boolean initialize(JavaPlugin plugin) {
        javaPlugin = plugin;
        Class<?> serverClass = javaPlugin.getServer().getClass();
        ReflectionHelper.giveReflectiveAccess(serverClass, ReflectionHelper.class);
        String packageName = serverClass.getPackage().getName();
        int indexOfSubRevision = packageName.indexOf(82);
        if (indexOfSubRevision > 0) {
            packageName = packageName.substring(0, indexOfSubRevision - 1);
        }
        try {
            version = NMSVersion.valueOf(packageName.substring(packageName.lastIndexOf(46) + 1));
        }
        catch (Exception e) {
            version = NMSVersion.NOT_SUPPORTED;
            instance = null;
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.denizenscript.denizen.nms." + version.name() + ".Handler");
            if (NMSHandler.class.isAssignableFrom(clazz)) {
                instance = (NMSHandler)clazz.newInstance();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        version = NMSVersion.NOT_SUPPORTED;
        instance = null;
        return false;
    }

    public static NMSHandler getInstance() {
        return instance;
    }

    public static NMSVersion getVersion() {
        return version;
    }

    public static JavaPlugin getJavaPlugin() {
        return javaPlugin;
    }

    public static AdvancementHelper getAdvancementHelper() {
        return NMSHandler.getInstance().advancementHelper;
    }

    public static AnimationHelper getAnimationHelper() {
        return NMSHandler.getInstance().animationHelper;
    }

    public static BlockHelper getBlockHelper() {
        return NMSHandler.getInstance().blockHelper;
    }

    public static ChunkHelper getChunkHelper() {
        return NMSHandler.getInstance().chunkHelper;
    }

    public static CustomEntityHelper getCustomEntityHelper() {
        return NMSHandler.getInstance().customEntityHelper;
    }

    public static EntityHelper getEntityHelper() {
        return NMSHandler.getInstance().entityHelper;
    }

    public static FishingHelper getFishingHelper() {
        return NMSHandler.getInstance().fishingHelper;
    }

    public static ItemHelper getItemHelper() {
        return NMSHandler.getInstance().itemHelper;
    }

    public static SoundHelper getSoundHelper() {
        return NMSHandler.getInstance().soundHelper;
    }

    public static PacketHelper getPacketHelper() {
        return NMSHandler.getInstance().packetHelper;
    }

    public static ParticleHelper getParticleHelper() {
        return NMSHandler.getInstance().particleHelper;
    }

    public static PlayerHelper getPlayerHelper() {
        return NMSHandler.getInstance().playerHelper;
    }

    public static WorldHelper getWorldHelper() {
        return NMSHandler.getInstance().worldHelper;
    }

    public boolean isCorrectMappingsCode() {
        return true;
    }

    public abstract void disableAsyncCatcher();

    public abstract void undisableAsyncCatcher();

    public abstract Sidebar createSidebar(Player var1);

    public abstract BlockLight createBlockLight(Location var1, int var2, long var3);

    public abstract PlayerProfile fillPlayerProfile(PlayerProfile var1);

    public abstract PlayerProfile getPlayerProfile(Player var1);

    public abstract ProfileEditor getProfileEditor();

    public abstract BiomeNMS getBiomeNMS(Biome var1);

    public abstract double[] getRecentTps();

    public abstract void enablePacketInterception(DenizenPacketHandler var1);

    public abstract CompoundTag createCompoundTag(Map<String, Tag> var1);

    public abstract int getPort();

    public abstract String getTitle(Inventory var1);

    public abstract String stringForHover(HoverEvent var1);

    public abstract boolean containerHas(PersistentDataContainer var1, NamespacedKey var2);

    public abstract String containerGetString(PersistentDataContainer var1, NamespacedKey var2);

    static {
        debugPackets = false;
    }
}

