/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.impl.network.handlers;

import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutMapChunk;
import net.minecraft.util.DataBits;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;

public class FakeBlockHelper {
    public static Field DATA_MAPCHUNK = ReflectionHelper.getFields(PacketPlayOutMapChunk.class).get((Object)ReflectionMappingsInfo.ClientboundLevelChunkPacket_buffer);
    public static Field BLOCKENTITIES_MAPCHUNK = ReflectionHelper.getFields(PacketPlayOutMapChunk.class).get((Object)ReflectionMappingsInfo.ClientboundLevelChunkPacket_blockEntitiesTags);

    public static IBlockData getNMSState(FakeBlock block) {
        return ((CraftBlockData)block.material.getModernData()).getState();
    }

    public static boolean anyBlocksInSection(List<FakeBlock> blocks, int y) {
        int minY = y << 4;
        int maxY = (y << 4) + 16;
        for (FakeBlock block : blocks) {
            int blockY = block.location.getBlockY();
            if (blockY < minY || blockY >= maxY) continue;
            return true;
        }
        return false;
    }

    public static int indexInPalette(IBlockData data) {
        return ChunkSection.d.a((Object)data);
    }

    public static int blockArrayIndex(int x, int y, int z) {
        return y * 256 + z * 16 + x;
    }

    public static int getPaletteSubId(int[] palette, int id) {
        for (int i = 0; i < palette.length; ++i) {
            if (palette[i] != id) continue;
            return i;
        }
        return -1;
    }

    public static PacketPlayOutMapChunk handleMapChunkPacket(PacketPlayOutMapChunk originalPacket, List<FakeBlock> blocks) {
        try {
            PacketPlayOutMapChunk packet = new PacketPlayOutMapChunk(DenizenNetworkManagerImpl.copyPacket(originalPacket));
            BitSet bitmask = packet.e();
            PacketDataSerializer serial = originalPacket.b();
            PacketDataSerializer outputSerial = new PacketDataSerializer(Unpooled.buffer((int)serial.readableBytes()));
            ArrayList<NBTTagCompound> blockEntities = new ArrayList<NBTTagCompound>(packet.g());
            BLOCKENTITIES_MAPCHUNK.set(packet, blockEntities);
            ListIterator iterator = blockEntities.listIterator();
            block2: while (iterator.hasNext()) {
                NBTTagCompound blockEnt = (NBTTagCompound)iterator.next();
                int x = blockEnt.getInt("x");
                int y = blockEnt.getInt("y");
                int z = blockEnt.getInt("z");
                for (FakeBlock block : blocks) {
                    LocationTag loc = block.location;
                    if (loc.getBlockX() != x || loc.getBlockY() != y || loc.getBlockZ() != z) continue;
                    iterator.remove();
                    continue block2;
                }
            }
            for (FakeBlock block : blocks) {
                LocationTag loc = block.location;
                NBTTagCompound newCompound = new NBTTagCompound();
                newCompound.setInt("x", loc.getBlockX());
                newCompound.setInt("y", loc.getBlockY());
                newCompound.setInt("z", loc.getBlockZ());
                newCompound.setString("id", block.material.getMaterial().getKey().toString());
                blockEntities.add(newCompound);
            }
            for (int y = 0; y < 16; ++y) {
                if (!bitmask.get(y)) continue;
                short blockCount = serial.readShort();
                int width = serial.readUnsignedByte();
                int paletteLen = serial.j();
                int[] palette = new int[paletteLen];
                for (int p = 0; p < paletteLen; ++p) {
                    palette[p] = serial.j();
                }
                int dataLen = serial.j();
                long[] blockListHelper = new long[dataLen];
                for (int i = 0; i < blockListHelper.length; ++i) {
                    blockListHelper[i] = serial.readLong();
                }
                outputSerial.writeShort((int)blockCount);
                if (!FakeBlockHelper.anyBlocksInSection(blocks, y)) {
                    outputSerial.writeByte(width);
                    outputSerial.d(paletteLen);
                    for (int p = 0; p < paletteLen; ++p) {
                        outputSerial.d(palette[p]);
                    }
                    outputSerial.a(blockListHelper);
                    continue;
                }
                char dataBitsF = (char)(64 / width);
                int expectedLength = (4096 + dataBitsF - 1) / dataBitsF;
                if (blockListHelper.length != expectedLength) {
                    return originalPacket;
                }
                DataBits bits = new DataBits(width, 4096, blockListHelper);
                int minY = y << 4;
                int maxY = (y << 4) + 16;
                for (FakeBlock block : blocks) {
                    int blockY = block.location.getBlockY();
                    if (blockY < minY || blockY >= maxY) continue;
                    int blockX = block.location.getBlockX();
                    int blockZ = block.location.getBlockZ();
                    blockX -= (blockX >> 4) * 16;
                    blockY -= (blockY >> 4) * 16;
                    blockZ -= (blockZ >> 4) * 16;
                    int blockIndex = FakeBlockHelper.blockArrayIndex(blockX, blockY, blockZ);
                    IBlockData replacementData = FakeBlockHelper.getNMSState(block);
                    int globalPaletteIndex = FakeBlockHelper.indexInPalette(replacementData);
                    int subPaletteId = FakeBlockHelper.getPaletteSubId(palette, globalPaletteIndex);
                    if (subPaletteId == -1) {
                        int[] newPalette = new int[paletteLen + 1];
                        if (paletteLen >= 0) {
                            System.arraycopy(palette, 0, newPalette, 0, paletteLen);
                        }
                        newPalette[paletteLen] = globalPaletteIndex;
                        subPaletteId = paletteLen++;
                        palette = newPalette;
                        int newWidth = MathHelper.e((int)paletteLen);
                        if (newWidth > width) {
                            DataBits newBits = new DataBits(newWidth, 4096);
                            for (int i = 0; i < bits.b(); ++i) {
                                newBits.a(i, bits.a(i));
                            }
                            bits = newBits;
                            width = newWidth;
                        }
                    }
                    bits.a(blockIndex, subPaletteId);
                }
                outputSerial.writeByte(width);
                outputSerial.d(paletteLen);
                for (int p = 0; p < palette.length; ++p) {
                    outputSerial.d(palette[p]);
                }
                outputSerial.a(bits.a());
            }
            int[] biomes = packet.h();
            if (biomes != null) {
                outputSerial.a(biomes);
            }
            byte[] outputBytes = outputSerial.array();
            DATA_MAPCHUNK.set(packet, outputBytes);
            return packet;
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }
}

