/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;

public class DropCommand
extends AbstractCommand {
    public DropCommand() {
        this.setName("drop");
        this.setSyntax("drop [<entity_type>/xp/<item>|...] (<location>) (quantity:<#>) (speed:<#.#>) (delay:<duration>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (Material material : Material.values()) {
            if (!material.isItem()) continue;
            addOne.accept(material.name());
        }
        for (String itemScript : ItemScriptHelper.item_scripts.keySet()) {
            addOne.accept(itemScript);
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matches("experience", "exp", "xp")) {
                scriptEntry.addObject("action", new ElementTag(Action.DROP_EXP.toString()).setPrefix("action"));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrefix("speed") && arg.matchesFloat()) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("delay") && arg.matchesArgumentType(DurationTag.class) && arg.matchesPrefix("delay", "d")) {
                scriptEntry.addObject("delay", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("quantity") && arg.matchesInteger() && arg.matchesPrefix("quantity", "q", "qty", "a", "amt", "amount")) {
                if (arg.matchesPrefix("q", "qty")) {
                    Deprecations.qtyTags.warn(scriptEntry);
                }
                scriptEntry.addObject("quantity", arg.asElement().setPrefix("quantity"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesArgumentList(ItemTag.class)) {
                scriptEntry.addObject("action", new ElementTag(Action.DROP_ITEM.toString()).setPrefix("action"));
                scriptEntry.addObject("item", arg.asType(ListTag.class).filter(ItemTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("action", new ElementTag(Action.DROP_ENTITY.toString()).setPrefix("action"));
                scriptEntry.addObject("entity", arg.asType(EntityTag.class).setPrefix("entity"));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class).setPrefix("location"));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify something to drop!");
        }
        if (!scriptEntry.hasObject("location")) {
            if (Utilities.getEntryPlayer(scriptEntry) != null && Utilities.getEntryPlayer(scriptEntry).isOnline()) {
                scriptEntry.addObject("location", Utilities.getEntryPlayer(scriptEntry).getLocation().setPrefix("location"));
                Debug.echoDebug((Debuggable)scriptEntry, "Did not specify a location, assuming Player's location.");
            } else {
                throw new InvalidArgumentsException("Must specify a location!");
            }
        }
        if (!scriptEntry.hasObject("quantity")) {
            scriptEntry.addObject("quantity", new ElementTag("1"));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag quantity = scriptEntry.getElement("quantity");
        ElementTag action = scriptEntry.getElement("action");
        ElementTag speed = scriptEntry.getElement("speed");
        List items = (List)scriptEntry.getObject("item");
        EntityTag entity = (EntityTag)scriptEntry.getObjectTag("entity");
        DurationTag delay = (DurationTag)scriptEntry.getObjectTag("delay");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), action.debug() + location.debug() + quantity.debug() + (items != null ? DropCommand.db("items", items) : "") + (entity != null ? entity.debug() : "") + (speed != null ? speed.debug() : "") + (delay != null ? delay.debug() : ""));
        }
        ListTag entityList = new ListTag();
        switch (Action.valueOf(action.asString())) {
            case DROP_EXP: {
                EntityTag orb = new EntityTag(location.getWorld().spawnEntity((Location)location, EntityType.EXPERIENCE_ORB));
                ((ExperienceOrb)orb.getBukkitEntity()).setExperience(quantity.asInt());
                entityList.addObject(orb);
                break;
            }
            case DROP_ITEM: {
                for (ItemTag item : items) {
                    if (item.getMaterial().getMaterial() == Material.AIR) continue;
                    if (quantity.asInt() > 1 && item.isUnique()) {
                        Debug.echoDebug((Debuggable)scriptEntry, "Cannot drop multiples of this item because it is Unique!");
                    }
                    for (int x = 0; x < quantity.asInt(); ++x) {
                        EntityTag e = new EntityTag((Entity)location.getWorld().dropItem((Location)location, item.getItemStack()));
                        if (e.isValid()) {
                            e.setVelocity(e.getVelocity().multiply(speed != null ? speed.asDouble() : 1.0));
                            if (delay != null) {
                                ((Item)e.getBukkitEntity()).setPickupDelay(delay.getTicksAsInt());
                            }
                        }
                        entityList.addObject(e);
                    }
                }
                break;
            }
            case DROP_ENTITY: {
                if (quantity.asInt() > 1 && entity.isUnique()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Cannot drop multiples of this entity because it is Unique!");
                    entity.spawnAt(location);
                    entityList.addObject(entity);
                    break;
                }
                for (int x = 0; x < quantity.asInt(); ++x) {
                    ArrayList<Mechanism> mechanisms = new ArrayList<Mechanism>();
                    for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                        mechanisms.add(new Mechanism(mechanism.getName(), mechanism.value, scriptEntry.context));
                    }
                    EntityTag ent = new EntityTag(entity.getEntityType(), mechanisms);
                    ent.spawnAt(location);
                    entityList.addObject(ent);
                }
                break;
            }
        }
        scriptEntry.addObject("dropped_entities", entityList);
        if (entityList.size() == 1) {
            scriptEntry.addObject("dropped_entity", entityList.getObject(0));
        }
    }

    static enum Action {
        DROP_ITEM,
        DROP_EXP,
        DROP_ENTITY;

    }
}

