/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.List;

public class EntityHealth
implements Property {
    public static final String[] handledTags = new String[]{"health", "formatted_health", "health_max", "health_percentage", "health_data"};
    public static final String[] handledMechs = new String[]{"max_health", "health_data", "health"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).isLivingEntity();
    }

    public static EntityHealth getFrom(ObjectTag entity) {
        if (!EntityHealth.describes(entity)) {
            return null;
        }
        return new EntityHealth((EntityTag)entity);
    }

    private EntityHealth(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return CoreUtilities.doubleToString(this.entity.getLivingEntity().getHealth()) + "/" + CoreUtilities.doubleToString(this.entity.getLivingEntity().getMaxHealth());
    }

    @Override
    public String getPropertyId() {
        return "health_data";
    }

    public static ElementTag getHealthFormatted(EntityTag entity, Double maxHealth) {
        if (maxHealth == null) {
            maxHealth = entity.getLivingEntity().getMaxHealth();
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.1) {
            return new ElementTag("dying");
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.4) {
            return new ElementTag("seriously wounded");
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 0.75) {
            return new ElementTag("injured");
        }
        if ((double)((float)entity.getLivingEntity().getHealth()) / maxHealth < 1.0) {
            return new ElementTag("scraped");
        }
        return new ElementTag("healthy");
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("formatted_health")) {
            return EntityHealth.getHealthFormatted(this.entity, attribute.hasParam() ? Double.valueOf(attribute.getDoubleParam()) : null);
        }
        if (attribute.startsWith("health.formatted")) {
            Deprecations.entityHealthTags.warn(attribute.context);
            return EntityHealth.getHealthFormatted(this.entity, attribute.hasContext(2) ? Double.valueOf(attribute.getDoubleContext(2)) : null);
        }
        if (attribute.startsWith("health_max")) {
            return new ElementTag(this.entity.getLivingEntity().getMaxHealth()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.max")) {
            Deprecations.entityHealthTags.warn(attribute.context);
            return new ElementTag(this.entity.getLivingEntity().getMaxHealth()).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health_percentage")) {
            double maxHealth = this.entity.getLivingEntity().getMaxHealth();
            if (attribute.hasParam()) {
                maxHealth = attribute.getIntParam();
            }
            return new ElementTag(this.entity.getLivingEntity().getHealth() / maxHealth * 100.0).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.percentage")) {
            Deprecations.entityHealthTags.warn(attribute.context);
            double maxHealth = this.entity.getLivingEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            return new ElementTag(this.entity.getLivingEntity().getHealth() / maxHealth * 100.0).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health_data")) {
            return new ElementTag(this.getPropertyString()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health")) {
            return new ElementTag(this.entity.getLivingEntity().getHealth()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("max_health") && mechanism.requireDouble()) {
            if (this.entity.isCitizensNPC()) {
                if (this.entity.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    ((HealthTrait)this.entity.getDenizenNPC().getCitizen().getOrAddTrait(HealthTrait.class)).setMaxhealth(mechanism.getValue().asInt());
                } else {
                    mechanism.echoError("NPC doesn't have health trait!");
                }
            } else if (this.entity.isLivingEntity()) {
                this.entity.getLivingEntity().setMaxHealth(mechanism.getValue().asDouble());
            } else {
                mechanism.echoError("Entity is not alive!");
            }
        }
        if (mechanism.matches("health_data")) {
            if (this.entity.isLivingEntity()) {
                List<String> values = CoreUtilities.split(mechanism.getValue().asString(), '/');
                this.entity.getLivingEntity().setMaxHealth(Double.parseDouble(values.get(1)));
                this.entity.getLivingEntity().setHealth(Double.parseDouble(values.get(0)));
            } else {
                mechanism.echoError("Entity is not alive!");
            }
        }
        if (mechanism.matches("health") && mechanism.requireDouble()) {
            if (this.entity.isLivingEntity()) {
                this.entity.getLivingEntity().setHealth(mechanism.getValue().asDouble());
            } else {
                mechanism.echoError("Entity is not alive!");
            }
        }
    }
}

