/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class RepeatCommand
extends BracedCommand {
    public RepeatCommand() {
        this.setName("repeat");
        this.setSyntax("repeat [stop/next/<amount>] (from:<#>) (as:<name>) [<commands>]");
        this.setRequiredArguments(1, 3);
        this.isProcedural = true;
        this.setPrefixesHandled("from", "as");
        this.setBooleansHandled("stop", "next", "\u0000callback");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matchesInteger() && !arg.hasPrefix()) {
                scriptEntry.addObject("quantity", arg.asElement());
                continue;
            }
            if (arg.matches("{")) break;
            arg.reportUnhandled();
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        boolean stop = scriptEntry.argAsBoolean("stop");
        boolean next = scriptEntry.argAsBoolean("next");
        boolean callback = scriptEntry.argAsBoolean("\u0000callback");
        ScriptQueue queue = scriptEntry.getResidingQueue();
        if (stop) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), RepeatCommand.db("instruction", "stop"));
            }
            boolean hasnext = false;
            for (int i = 0; i < queue.getQueueSize(); ++i) {
                ScriptEntry entry = queue.getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equals("REPEAT") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (queue.getQueueSize() > 0) {
                    ScriptEntry entry = queue.getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (entry.getCommandName().equals("REPEAT") && args.size() == 1 && args.get(0).equals("\u0000CALLBACK")) {
                        ((RepeatData)entry.getOwner().getData()).reapplyAtEnd(queue);
                        queue.removeFirst();
                        break;
                    }
                    queue.removeFirst();
                }
            } else {
                Debug.echoError("Cannot stop repeat: not in one!");
            }
            return;
        }
        if (next) {
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), RepeatCommand.db("instruction", "next"));
            }
            boolean hasnext = false;
            for (int i = 0; i < queue.getQueueSize(); ++i) {
                ScriptEntry entry = queue.getEntry(i);
                List<String> args = entry.getOriginalArguments();
                if (!entry.getCommandName().equals("REPEAT") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) continue;
                hasnext = true;
                break;
            }
            if (hasnext) {
                while (queue.getQueueSize() > 0) {
                    ScriptEntry entry = queue.getEntry(0);
                    List<String> args = entry.getOriginalArguments();
                    if (!entry.getCommandName().equals("REPEAT") || args.size() != 1 || !args.get(0).equals("\u0000CALLBACK")) {
                        queue.removeFirst();
                        continue;
                    }
                    break;
                }
            } else {
                Debug.echoError("Cannot 'repeat next': not in one!");
            }
            return;
        }
        if (callback) {
            if (scriptEntry.getOwner() != null && (scriptEntry.getOwner().getCommandName().equals("REPEAT") || scriptEntry.getOwner().getBracedSet() == null || scriptEntry.getOwner().getBracedSet().isEmpty() || scriptEntry.getBracedSet().get((int)0).value.get(scriptEntry.getBracedSet().get((int)0).value.size() - 1) != scriptEntry)) {
                RepeatData data = (RepeatData)scriptEntry.getOwner().getData();
                ++data.index;
                if (data.index <= data.target) {
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, "Repeat loop " + data.index);
                    }
                    queue.addDefinition(data.valueName, String.valueOf(data.index));
                    List<ScriptEntry> bracedCommands = BracedCommand.getBracedCommandsDirect(scriptEntry.getOwner(), scriptEntry);
                    ScriptEntry callbackEntry = scriptEntry.clone();
                    callbackEntry.copyFrom(scriptEntry);
                    callbackEntry.setOwner(scriptEntry.getOwner());
                    bracedCommands.add(callbackEntry);
                    for (ScriptEntry cmd : bracedCommands) {
                        cmd.setInstant(true);
                    }
                    queue.injectEntriesAtStart(bracedCommands);
                } else {
                    data.reapplyAtEnd(queue);
                    if (scriptEntry.dbCallShouldDebug()) {
                        Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, "Repeat loop complete");
                    }
                }
            } else {
                Debug.echoError("Repeat CALLBACK invalid: not a real callback!");
            }
        } else {
            int target;
            ElementTag as_name = scriptEntry.argForPrefixAsElement("as", "value");
            ElementTag from = scriptEntry.argForPrefixAsElement("from", "1");
            ElementTag quantity = scriptEntry.getElement("quantity");
            if (quantity == null) {
                throw new InvalidArgumentsRuntimeException("Must specify a quantity or 'stop' or 'next'!");
            }
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), from, quantity, as_name);
            }
            if ((target = quantity.asInt()) <= 0) {
                if (scriptEntry.dbCallShouldDebug()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "Zero count, not looping...");
                }
                return;
            }
            RepeatData datum = new RepeatData();
            datum.index = from.asInt();
            datum.target = datum.index + target - 1;
            datum.valueName = as_name.asString();
            scriptEntry.setData(datum);
            ScriptEntry callbackEntry = new ScriptEntry("REPEAT", new String[]{"\u0000CALLBACK"}, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null);
            List<ScriptEntry> bracedCommandsList = RepeatCommand.getBracedCommandsDirect(scriptEntry, scriptEntry);
            if (bracedCommandsList == null || bracedCommandsList.isEmpty()) {
                Debug.echoError(scriptEntry, "Empty subsection - did you forget a ':'?");
                return;
            }
            datum.originalValue = queue.getDefinitionObject(datum.valueName);
            queue.addDefinition(datum.valueName, String.valueOf(datum.index));
            callbackEntry.copyFrom(scriptEntry);
            callbackEntry.setOwner(scriptEntry);
            bracedCommandsList.add(callbackEntry);
            for (ScriptEntry cmd : bracedCommandsList) {
                cmd.setInstant(true);
            }
            scriptEntry.setInstant(true);
            queue.injectEntriesAtStart(bracedCommandsList);
        }
    }

    private static class RepeatData {
        public int index;
        public int target;
        public String valueName;
        public ObjectTag originalValue;

        private RepeatData() {
        }

        public void reapplyAtEnd(ScriptQueue queue) {
            queue.addDefinition(this.valueName, this.originalValue);
        }
    }
}

