/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class TablistCommand
extends AbstractCommand {
    public TablistCommand() {
        this.setName("tablist");
        this.setSyntax("tablist [add/remove/update] (name:<name>) (display:<display>) (uuid:<uuid>) (skin_blob:<blob>) (latency:<#>) (gamemode:creative/survival/adventure/spectator)");
        this.setRequiredArguments(2, 7);
        this.isProcedural = false;
        this.setPrefixesHandled("name", "display", "uuid", "skin_blob", "latency", "gamemode");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("mode") && arg.matchesEnum(Mode.class)) {
                scriptEntry.addObject("mode", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("mode")) {
            throw new InvalidArgumentsException("Missing add/remove/update argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        int latencyNum;
        Mode mode = scriptEntry.getElement("mode").asEnum(Mode.class);
        ElementTag name = scriptEntry.argForPrefixAsElement("name", null);
        ElementTag display = scriptEntry.argForPrefixAsElement("display", null);
        ElementTag uuid = scriptEntry.argForPrefixAsElement("uuid", null);
        ElementTag skinBlob = scriptEntry.argForPrefixAsElement("skin_blob", null);
        ElementTag latency = scriptEntry.argForPrefixAsElement("latency", null);
        ElementTag gamemode = scriptEntry.argForPrefixAsElement("gamemode", "creative");
        Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), new Object[]{mode, name, display, uuid, gamemode, latency, skinBlob});
        }
        UUID id = null;
        if (uuid != null) {
            try {
                id = UUID.fromString(uuid.asString());
            }
            catch (IllegalArgumentException ex) {
                Debug.echoError("Invalid UUID '" + uuid + "'");
                return;
            }
        } else {
            id = UUID.randomUUID();
        }
        String texture = null;
        String signature = null;
        if (skinBlob != null) {
            int semicolon = skinBlob.asString().indexOf(59);
            if (semicolon == -1) {
                Debug.echoError("Invalid skinblob '" + skinBlob + "'");
                return;
            }
            texture = skinBlob.asString().substring(0, semicolon);
            signature = skinBlob.asString().substring(semicolon + 1);
        }
        if (latency != null && !latency.isInt()) {
            Debug.echoError("Invalid latency, not a number '" + latency + "'");
            return;
        }
        int n = latencyNum = latency == null ? 0 : latency.asInt();
        if (!gamemode.matchesEnum(GameMode.class)) {
            Debug.echoError("Invalid gamemode '" + gamemode + "'");
            return;
        }
        GameMode gameModeBukkit = gamemode.asEnum(GameMode.class);
        switch (mode) {
            case ADD: {
                if (name == null) {
                    throw new InvalidArgumentsRuntimeException("'name' wasn't specified but is required for 'add'");
                }
                if (!(display != null && display.asString().length() <= 0 || CoreConfiguration.allowRestrictedActions)) {
                    Debug.echoError("Cannot use 'tablist add' to add a non-empty display-named entry: 'Allow restricted actions' is disabled in Denizen config.yml.");
                    return;
                }
                NMSHandler.playerHelper.sendPlayerInfoAddPacket(player, PlayerHelper.ProfileEditMode.ADD, name.asString(), CoreUtilities.stringifyNullPass(display), id, texture, signature, latencyNum, gameModeBukkit);
                break;
            }
            case REMOVE: {
                if (uuid == null) {
                    throw new InvalidArgumentsRuntimeException("'uuid' wasn't specified but is required for 'remove'");
                }
                NMSHandler.playerHelper.sendPlayerRemovePacket(player, id);
                break;
            }
            case UPDATE: {
                if (uuid == null) {
                    throw new InvalidArgumentsRuntimeException("'uuid' wasn't specified but is required for 'update'");
                }
                if (!(display != null && display.asString().length() <= 0 || CoreConfiguration.allowRestrictedActions)) {
                    Debug.echoError("Cannot use 'tablist update' to create a non-empty named entry: 'Allow restricted actions' is disabled in Denizen config.yml.");
                    return;
                }
                if (display != null) {
                    NMSHandler.playerHelper.sendPlayerInfoAddPacket(player, PlayerHelper.ProfileEditMode.UPDATE_DISPLAY, CoreUtilities.stringifyNullPass(name), CoreUtilities.stringifyNullPass(display), id, texture, signature, latencyNum, gameModeBukkit);
                }
                if (latency == null) break;
                NMSHandler.playerHelper.sendPlayerInfoAddPacket(player, PlayerHelper.ProfileEditMode.UPDATE_LATENCY, CoreUtilities.stringifyNullPass(name), CoreUtilities.stringifyNullPass(display), id, texture, signature, latencyNum, gameModeBukkit);
            }
        }
    }

    public static enum Mode {
        ADD,
        REMOVE,
        UPDATE;

    }
}

